## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::cpan::distname;

our $DATE = '2022-09-25'; # DATE
our $VERSION = '0.014'; # VERSION

our $rschema = do{my$var={base=>"perl::distname",clsets_after_base=>[{description=>"\nLike perl::distname, but with completion from distribution names on CPAN (using\nlcpan).\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>"Foo-Bar",value=>"Foo-Bar"},{valid=>1,validated_value=>"Foo-Bar",value=>"Foo::Bar"}],summary=>"A distribution name on CPAN, e.g. \"Module-Installed-Tiny\"","x.completion"=>["lcpan_distname"]}],clsets_after_type=>[{description=>"\nThis is a schema you can use when you want to accept a Perl distribution name,\ne.g. `WWW-Mechanize`. It offers basic checking of syntax as well as a couple of\nconveniences. First, it offers completion from list of locally installed Perl\ndistribution. Second, it contains coercion rule so you can also input\n`Foo::Bar`, `Foo/Bar`, `Foo/Bar.pm`, or even 'Foo.Bar' and it will be normalized\ninto `Foo-Bar`.\n\nTo see this schema in action on the CLI, you can try e.g. the `dist-has-deb`\nscript from <pm:App::DistUtils> and activate its tab completion (see its manpage\nfor more details). Then on the CLI try typing:\n\n    % dist-has-deb WWW-<tab>\n    % dist-has-deb dzp/<tab>\n\nNote that this schema does not check that the Perl disribution exists on CPAN or\nis installed locally. To check that, use the `perl::distname::installed` schema.\nAnd there's also a `perl::distname::not_installed` schema.\n\n",match=>"\\A[A-Za-z_][A-Za-z_0-9]*(-[A-Za-z_0-9]+)*\\z",summary=>"Perl distribution name, e.g. Foo-Bar","x.completion"=>"perl_distname","x.perl.coerce_rules"=>["From_str::normalize_perl_distname"]},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_base}[0]'],resolve_path=>["str","perl::distname"],type=>"str",v=>2};$var->{clsets_after_type}[1]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: A distribution name on CPAN, e.g. "Module-Installed-Tiny"

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::cpan::distname - A distribution name on CPAN, e.g. "Module-Installed-Tiny"

=head1 VERSION

This document describes version 0.014 of Sah::SchemaR::cpan::distname (from Perl distribution Sah-Schemas-CPAN), released on 2022-09-25.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-CPAN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-CPAN>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2021, 2020, 2019, 2018, 2017 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-CPAN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
