#!/usr/bin/perl

package eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyeBaySellingResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingResponseType

=head1 DESCRIPTION

Returns summary and detail information about items the user is selling,
items scheduled to sell, currently listed, sold, and closed but not sold.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::MyeBaySellingSummaryType;
use eBay::API::XML::DataType::PaginatedItemArrayType;
use eBay::API::XML::DataType::PaginatedOrderTransactionArrayType;
use eBay::API::XML::DataType::SellingSummaryType;


my @gaProperties = ( [ 'ActiveList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'BidList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'DeletedFromSoldList', 'ns:PaginatedOrderTransactionArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType', '1' ]
	, [ 'DeletedFromUnsoldList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'ScheduledList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'SellingSummary', 'ns:SellingSummaryType', ''
	     ,'eBay::API::XML::DataType::SellingSummaryType', '1' ]
	, [ 'SoldList', 'ns:PaginatedOrderTransactionArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType', '1' ]
	, [ 'Summary', 'ns:MyeBaySellingSummaryType', ''
	     ,'eBay::API::XML::DataType::MyeBaySellingSummaryType', '1' ]
	, [ 'UnsoldList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setActiveList()

Contains the items the user is selling that have active listings.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setActiveList {
  my $self = shift;
  $self->{'ActiveList'} = shift
}

=head2 getActiveList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getActiveList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ActiveList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setBidList()

Contains the seller's active listings with bids.
Only returned if items exist that meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setBidList {
  my $self = shift;
  $self->{'BidList'} = shift
}

=head2 getBidList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getBidList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setDeletedFromSoldList()

Contains the items the seller has sold and deleted from My eBay.

#    Argument: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub setDeletedFromSoldList {
  my $self = shift;
  $self->{'DeletedFromSoldList'} = shift
}

=head2 getDeletedFromSoldList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub getDeletedFromSoldList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DeletedFromSoldList'
		,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType');
}


=head2 setDeletedFromUnsoldList()

Contains the items with listings that were ended or did not sell and have been deleted from My eBay.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setDeletedFromUnsoldList {
  my $self = shift;
  $self->{'DeletedFromUnsoldList'} = shift
}

=head2 getDeletedFromUnsoldList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getDeletedFromUnsoldList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DeletedFromUnsoldList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setScheduledList()

Contains the items the user has scheduled for sale, but whose listings have
not yet started.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setScheduledList {
  my $self = shift;
  $self->{'ScheduledList'} = shift
}

=head2 getScheduledList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getScheduledList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ScheduledList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setSellingSummary()

Contains summary information about the items the user is selling.

#    Argument: 'ns:SellingSummaryType'

=cut

sub setSellingSummary {
  my $self = shift;
  $self->{'SellingSummary'} = shift
}

=head2 getSellingSummary()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:SellingSummaryType'

=cut

sub getSellingSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellingSummary'
		,'eBay::API::XML::DataType::SellingSummaryType');
}


=head2 setSoldList()

Contains the items the user has sold.

#    Argument: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub setSoldList {
  my $self = shift;
  $self->{'SoldList'} = shift
}

=head2 getSoldList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub getSoldList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SoldList'
		,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType');
}


=head2 setSummary()

Contains summary information about the items the user is selling.

#    Argument: 'ns:MyeBaySellingSummaryType'

=cut

sub setSummary {
  my $self = shift;
  $self->{'Summary'} = shift
}

=head2 getSummary()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:MyeBaySellingSummaryType'

=cut

sub getSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Summary'
		,'eBay::API::XML::DataType::MyeBaySellingSummaryType');
}


=head2 setUnsoldList()

Contains the items whose listings have ended but that have not sold.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setUnsoldList {
  my $self = shift;
  $self->{'UnsoldList'} = shift
}

=head2 getUnsoldList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getUnsoldList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UnsoldList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
