# Generated by default/object.tt
package Paws::NetworkFirewall::Header;
  use Moose;
  has Destination => (is => 'ro', isa => 'Str', required => 1);
  has DestinationPort => (is => 'ro', isa => 'Str', required => 1);
  has Direction => (is => 'ro', isa => 'Str', required => 1);
  has Protocol => (is => 'ro', isa => 'Str', required => 1);
  has Source => (is => 'ro', isa => 'Str', required => 1);
  has SourcePort => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::Header

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::Header object:

  $service_obj->Method(Att1 => { Destination => $value, ..., SourcePort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::Header object:

  $result = $service_obj->Method(...);
  $result->Att1->Destination

=head1 DESCRIPTION

The 5-tuple criteria for AWS Network Firewall to use to inspect packet
headers in stateful traffic flow inspection. Traffic flows that match
the criteria are a match for the corresponding StatefulRule.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Destination => Str

The destination IP address or address range to inspect for, in CIDR
notation. To match with any address, specify C<ANY>.

Specify an IP address or a block of IP addresses in Classless
Inter-Domain Routing (CIDR) notation. Network Firewall supports all
address ranges for IPv4.

Examples:

=over

=item *

To configure Network Firewall to inspect for the IP address 192.0.2.44,
specify C<192.0.2.44/32>.

=item *

To configure Network Firewall to inspect for IP addresses from
192.0.2.0 to 192.0.2.255, specify C<192.0.2.0/24>.

=back

For more information about CIDR notation, see the Wikipedia entry
Classless Inter-Domain Routing
(https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).


=head2 B<REQUIRED> DestinationPort => Str

The destination port to inspect for. You can specify an individual
port, for example C<1994> and you can specify a port range, for example
C<1990-1994>. To match with any port, specify C<ANY>.


=head2 B<REQUIRED> Direction => Str

The direction of traffic flow to inspect. If set to C<ANY>, the
inspection matches bidirectional traffic, both from the source to the
destination and from the destination to the source. If set to
C<FORWARD>, the inspection only matches traffic going from the source
to the destination.


=head2 B<REQUIRED> Protocol => Str

The protocol to inspect for. To specify all, you can use C<IP>, because
all traffic on AWS and on the internet is IP.


=head2 B<REQUIRED> Source => Str

The source IP address or address range to inspect for, in CIDR
notation. To match with any address, specify C<ANY>.

Specify an IP address or a block of IP addresses in Classless
Inter-Domain Routing (CIDR) notation. Network Firewall supports all
address ranges for IPv4.

Examples:

=over

=item *

To configure Network Firewall to inspect for the IP address 192.0.2.44,
specify C<192.0.2.44/32>.

=item *

To configure Network Firewall to inspect for IP addresses from
192.0.2.0 to 192.0.2.255, specify C<192.0.2.0/24>.

=back

For more information about CIDR notation, see the Wikipedia entry
Classless Inter-Domain Routing
(https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).


=head2 B<REQUIRED> SourcePort => Str

The source port to inspect for. You can specify an individual port, for
example C<1994> and you can specify a port range, for example
C<1990-1994>. To match with any port, specify C<ANY>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

