## test texts, converted to Perl syntax
##
## megatest texts, C-ified
##
## Copyright 2010 Kurt Hackenberg & William S. Yerazunis, each individually
## with full rights to relicense.
##
##   This collection contains texts in the public domain; the copyright
##   is not on the texts themselves but on their use as test texts for
##   the LGPLed CRM114 Library.
##
##
##   This file is part of the CRM114 Library.
##
##   The CRM114 Library is free software: you can redistribute it and/or modify
##   it under the terms of the GNU Lesser General Public License as published by
##   the Free Software Foundation, either version 3 of the License, or
##   (at your option) any later version.
##
##   The CRM114 Library is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU Lesser General Public License for more details.
##
##   You should have received a copy of the GNU Lesser General Public License
##   along with the CRM114 Library.  If not, see <http://www.gnu.org/licenses/>.

use strict;
package SampleText;


sub Alice { return "CHAPTER I. Down the Rabbit-Hole\n"
."\n"
."Alice was beginning to get very tired of sitting by her sister on the\n"
."bank, and of having nothing to do: once or twice she had peeped into the\n"
."book her sister was reading, but it had no pictures or conversations in\n"
."it, 'and what is the use of a book,' thought Alice 'without pictures or\n"
."conversation?'\n"
."\n"
."So she was considering in her own mind (as well as she could, for the\n"
."hot day made her feel very sleepy and stupid), whether the pleasure\n"
."of making a daisy-chain would be worth the trouble of getting up and\n"
."picking the daisies, when suddenly a White Rabbit with pink eyes ran\n"
."close by her.\n"
."\n"
."There was nothing so VERY remarkable in that; nor did Alice think it so\n"
."VERY much out of the way to hear the Rabbit say to itself, 'Oh dear!\n"
."Oh dear! I shall be late!' (when she thought it over afterwards, it\n"
."occurred to her that she ought to have wondered at this, but at the time\n"
."it all seemed quite natural); but when the Rabbit actually TOOK A WATCH\n"
."OUT OF ITS WAISTCOAT-POCKET, and looked at it, and then hurried on,\n"
."Alice started to her feet, for it flashed across her mind that she had\n"
."never before seen a rabbit with either a waistcoat-pocket, or a watch\n"
."to take out of it, and burning with curiosity, she ran across the field\n"
."after it, and fortunately was just in time to see it pop down a large\n"
."rabbit-hole under the hedge.\n"
."\n"
."In another moment down went Alice after it, never once considering how\n"
."in the world she was to get out again.\n"
."\n"
."The rabbit-hole went straight on like a tunnel for some way, and then\n"
."dipped suddenly down, so suddenly that Alice had not a moment to think\n"
."about stopping herself before she found herself falling down a very deep\n"
."well.\n"
."\n"
."Either the well was very deep, or she fell very slowly, for she had\n"
."plenty of time as she went down to look about her and to wonder what was\n"
."going to happen next. First, she tried to look down and make out what\n"
."she was coming to, but it was too dark to see anything; then she\n"
."looked at the sides of the well, and noticed that they were filled with\n"
."cupboards and book-shelves; here and there she saw maps and pictures\n"
."hung upon pegs. She took down a jar from one of the shelves as\n"
."she passed; it was labelled 'ORANGE MARMALADE', but to her great\n"
."disappointment it was empty: she did not like to drop the jar for fear\n"
."of killing somebody, so managed to put it into one of the cupboards as\n"
."she fell past it.\n"
."\n"
."'Well!' thought Alice to herself, 'after such a fall as this, I shall\n"
."think nothing of tumbling down stairs! How brave they'll all think me at\n"
."home! Why, I wouldn't say anything about it, even if I fell off the top\n"
."of the house!' (Which was very likely true.)\n"
."\n"
."Down, down, down. Would the fall NEVER come to an end! 'I wonder how\n"
."many miles I've fallen by this time?' she said aloud. 'I must be getting\n"
."somewhere near the centre of the earth. Let me see: that would be four\n"
."thousand miles down, I think--' (for, you see, Alice had learnt several\n"
."things of this sort in her lessons in the schoolroom, and though this\n"
."was not a VERY good opportunity for showing off her knowledge, as there\n"
."was no one to listen to her, still it was good practice to say it over)\n"
."'--yes, that's about the right distance--but then I wonder what Latitude\n"
."or Longitude I've got to?' (Alice had no idea what Latitude was, or\n"
."Longitude either, but thought they were nice grand words to say.)\n"
."\n"
."Presently she began again. 'I wonder if I shall fall right THROUGH the\n"
."earth! How funny it'll seem to come out among the people that walk with\n"
."their heads downward! The Antipathies, I think--' (she was rather glad\n"
."there WAS no one listening, this time, as it didn't sound at all the\n"
."right word) '--but I shall have to ask them what the name of the country\n"
."is, you know. Please, Ma'am, is this New Zealand or Australia?' (and\n"
."she tried to curtsey as she spoke--fancy CURTSEYING as you're falling\n"
."through the air! Do you think you could manage it?) 'And what an\n"
."ignorant little girl she'll think me for asking! No, it'll never do to\n"
."ask: perhaps I shall see it written up somewhere.'\n"
."\n"
."Down, down, down. There was nothing else to do, so Alice soon began\n"
."talking again. 'Dinah'll miss me very much to-night, I should think!'\n"
."(Dinah was the cat.) 'I hope they'll remember her saucer of milk at\n"
."tea-time. Dinah my dear! I wish you were down here with me! There are no\n"
."mice in the air, I'm afraid, but you might catch a bat, and that's very\n"
."like a mouse, you know. But do cats eat bats, I wonder?' And here Alice\n"
."began to get rather sleepy, and went on saying to herself, in a dreamy\n"
."sort of way, 'Do cats eat bats? Do cats eat bats?' and sometimes, 'Do\n"
."bats eat cats?' for, you see, as she couldn't answer either question,\n"
."it didn't much matter which way she put it. She felt that she was dozing\n"
."off, and had just begun to dream that she was walking hand in hand with\n"
."Dinah, and saying to her very earnestly, 'Now, Dinah, tell me the truth:\n"
."did you ever eat a bat?' when suddenly, thump! thump! down she came upon\n"
."a heap of sticks and dry leaves, and the fall was over.\n"
."\n"
."Alice was not a bit hurt, and she jumped up on to her feet in a moment:\n"
."she looked up, but it was all dark overhead; before her was another\n"
."long passage, and the White Rabbit was still in sight, hurrying down it.\n"
."There was not a moment to be lost: away went Alice like the wind, and\n"
."was just in time to hear it say, as it turned a corner, 'Oh my ears\n"
."and whiskers, how late it's getting!' She was close behind it when she\n"
."turned the corner, but the Rabbit was no longer to be seen: she found\n"
."herself in a long, low hall, which was lit up by a row of lamps hanging\n"
."from the roof.\n"
."\n"
."There were doors all round the hall, but they were all locked; and when\n"
."Alice had been all the way down one side and up the other, trying every\n"
."door, she walked sadly down the middle, wondering how she was ever to\n"
."get out again.\n"
."\n"
."Suddenly she came upon a little three-legged table, all made of solid\n"
."glass; there was nothing on it except a tiny golden key, and Alice's\n"
."first thought was that it might belong to one of the doors of the hall;\n"
."but, alas! either the locks were too large, or the key was too small,\n"
."but at any rate it would not open any of them. However, on the second\n"
."time round, she came upon a low curtain she had not noticed before, and\n"
."behind it was a little door about fifteen inches high: she tried the\n"
."little golden key in the lock, and to her great delight it fitted!\n"
."\n"
."Alice opened the door and found that it led into a small passage, not\n"
."much larger than a rat-hole: she knelt down and looked along the passage\n"
."into the loveliest garden you ever saw. How she longed to get out of\n"
."that dark hall, and wander about among those beds of bright flowers and\n"
."those cool fountains, but she could not even get her head through the\n"
."doorway; 'and even if my head would go through,' thought poor Alice, 'it\n"
."would be of very little use without my shoulders. Oh, how I wish I could\n"
."shut up like a telescope! I think I could, if I only know how to begin.'\n"
."For, you see, so many out-of-the-way things had happened lately,\n"
."that Alice had begun to think that very few things indeed were really\n"
."impossible.\n"
."\n"
."There seemed to be no use in waiting by the little door, so she went\n"
."back to the table, half hoping she might find another key on it, or at\n"
."any rate a book of rules for shutting people up like telescopes: this\n"
."time she found a little bottle on it, ('which certainly was not here\n"
."before,' said Alice,) and round the neck of the bottle was a paper\n"
."label, with the words 'DRINK ME' beautifully printed on it in large\n"
."letters.\n"
."\n"
."It was all very well to say 'Drink me,' but the wise little Alice was\n"
."not going to do THAT in a hurry. 'No, I'll look first,' she said, 'and\n"
."see whether it's marked \"poison\" or not'; for she had read several nice\n"
."little histories about children who had got burnt, and eaten up by wild\n"
."beasts and other unpleasant things, all because they WOULD not remember\n"
."the simple rules their friends had taught them: such as, that a red-hot\n"
."poker will burn you if you hold it too long; and that if you cut your\n"
."finger VERY deeply with a knife, it usually bleeds; and she had never\n"
."forgotten that, if you drink much from a bottle marked 'poison,' it is\n"
."almost certain to disagree with you, sooner or later.\n"
."\n"
."However, this bottle was NOT marked 'poison,' so Alice ventured to taste\n"
."it, and finding it very nice, (it had, in fact, a sort of mixed flavour\n"
."of cherry-tart, custard, pine-apple, roast turkey, toffee, and hot\n"
."buttered toast,) she very soon finished it off.\n"
."\n"
."  *    *    *    *    *    *    *\n"
."\n"
."    *    *    *    *    *    *\n"
."\n"
."  *    *    *    *    *    *    *\n"
."\n"
."'What a curious feeling!' said Alice; 'I must be shutting up like a\n"
."telescope.'\n"
."\n"
."And so it was indeed: she was now only ten inches high, and her face\n"
."brightened up at the thought that she was now the right size for going\n"
."through the little door into that lovely garden. First, however, she\n"
."waited for a few minutes to see if she was going to shrink any further:\n"
."she felt a little nervous about this; 'for it might end, you know,' said\n"
."Alice to herself, 'in my going out altogether, like a candle. I wonder\n"
."what I should be like then?' And she tried to fancy what the flame of a\n"
."candle is like after the candle is blown out, for she could not remember\n"
."ever having seen such a thing.\n"
."\n"
."After a while, finding that nothing more happened, she decided on going\n"
."into the garden at once; but, alas for poor Alice! when she got to the\n"
."door, she found she had forgotten the little golden key, and when she\n"
."went back to the table for it, she found she could not possibly reach\n"
."it: she could see it quite plainly through the glass, and she tried her\n"
."best to climb up one of the legs of the table, but it was too slippery;\n"
."and when she had tired herself out with trying, the poor little thing\n"
."sat down and cried.\n"
."\n"
."'Come, there's no use in crying like that!' said Alice to herself,\n"
."rather sharply; 'I advise you to leave off this minute!' She generally\n"
."gave herself very good advice, (though she very seldom followed it),\n"
."and sometimes she scolded herself so severely as to bring tears into\n"
."her eyes; and once she remembered trying to box her own ears for having\n"
."cheated herself in a game of croquet she was playing against herself,\n"
."for this curious child was very fond of pretending to be two people.\n"
."'But it's no use now,' thought poor Alice, 'to pretend to be two people!\n"
."Why, there's hardly enough of me left to make ONE respectable person!'\n"
."\n"
."Soon her eye fell on a little glass box that was lying under the table:\n"
."she opened it, and found in it a very small cake, on which the words\n"
."'EAT ME' were beautifully marked in currants. 'Well, I'll eat it,' said\n"
."Alice, 'and if it makes me grow larger, I can reach the key; and if it\n"
."makes me grow smaller, I can creep under the door; so either way I'll\n"
."get into the garden, and I don't care which happens!'\n"
."\n"
."She ate a little bit, and said anxiously to herself, 'Which way? Which\n"
."way?', holding her hand on the top of her head to feel which way it was\n"
."growing, and she was quite surprised to find that she remained the same\n"
."size: to be sure, this generally happens when one eats cake, but Alice\n"
."had got so much into the way of expecting nothing but out-of-the-way\n"
."things to happen, that it seemed quite dull and stupid for life to go on\n"
."in the common way.\n"
."\n"
."So she set to work, and very soon finished off the cake.\n"
."\n"
."  *    *    *    *    *    *    *\n"
."\n"
."    *    *    *    *    *    *\n"
."\n"
."  *    *    *    *    *    *    *\n"
."\n"
."\n"
."\n"
."\n"
."CHAPTER II. The Pool of Tears\n"
."\n"
."'Curiouser and curiouser!' cried Alice (she was so much surprised, that\n"
."for the moment she quite forgot how to speak good English); 'now I'm\n"
."opening out like the largest telescope that ever was! Good-bye, feet!'\n"
."(for when she looked down at her feet, they seemed to be almost out of\n"
."sight, they were getting so far off). 'Oh, my poor little feet, I wonder\n"
."who will put on your shoes and stockings for you now, dears? I'm sure\n"
."_I_ shan't be able! I shall be a great deal too far off to trouble\n"
."myself about you: you must manage the best way you can;--but I must be\n"
."kind to them,' thought Alice, 'or perhaps they won't walk the way I want\n"
."to go! Let me see: I'll give them a new pair of boots every Christmas.'\n"
."\n"
."And she went on planning to herself how she would manage it. 'They must\n"
."go by the carrier,' she thought; 'and how funny it'll seem, sending\n"
."presents to one's own feet! And how odd the directions will look!\n"
."\n"
."     ALICE'S RIGHT FOOT, ESQ.\n"
."       HEARTHRUG,\n"
."         NEAR THE FENDER,\n"
."           (WITH ALICE'S LOVE).\n"
."\n"
."Oh dear, what nonsense I'm talking!'\n"
."\n"
."Just then her head struck against the roof of the hall: in fact she was\n"
."now more than nine feet high, and she at once took up the little golden\n"
."key and hurried off to the garden door.\n"
."\n"
."Poor Alice! It was as much as she could do, lying down on one side, to\n"
."look through into the garden with one eye; but to get through was more\n"
."hopeless than ever: she sat down and began to cry again.\n"
."\n"
."'You ought to be ashamed of yourself,' said Alice, 'a great girl like\n"
."you,' (she might well say this), 'to go on crying in this way! Stop this\n"
."moment, I tell you!' But she went on all the same, shedding gallons of\n"
."tears, until there was a large pool all round her, about four inches\n"
."deep and reaching half down the hall.\n"
."\n"
."After a time she heard a little pattering of feet in the distance, and\n"
."she hastily dried her eyes to see what was coming. It was the White\n"
."Rabbit returning, splendidly dressed, with a pair of white kid gloves in\n"
."one hand and a large fan in the other: he came trotting along in a great\n"
."hurry, muttering to himself as he came, 'Oh! the Duchess, the Duchess!\n"
."Oh! won't she be savage if I've kept her waiting!' Alice felt so\n"
."desperate that she was ready to ask help of any one; so, when the Rabbit\n"
."came near her, she began, in a low, timid voice, 'If you please, sir--'\n"
."The Rabbit started violently, dropped the white kid gloves and the fan,\n"
."and skurried away into the darkness as hard as he could go.\n"
."\n"
."Alice took up the fan and gloves, and, as the hall was very hot, she\n"
."kept fanning herself all the time she went on talking: 'Dear, dear! How\n"
."queer everything is to-day! And yesterday things went on just as usual.\n"
."I wonder if I've been changed in the night? Let me think: was I the\n"
."same when I got up this morning? I almost think I can remember feeling a\n"
."little different. But if I'm not the same, the next question is, Who\n"
."in the world am I? Ah, THAT'S the great puzzle!' And she began thinking\n"
."over all the children she knew that were of the same age as herself, to\n"
."see if she could have been changed for any of them.\n"
."\n"
."'I'm sure I'm not Ada,' she said, 'for her hair goes in such long\n"
."ringlets, and mine doesn't go in ringlets at all; and I'm sure I can't\n"
."be Mabel, for I know all sorts of things, and she, oh! she knows such a\n"
."very little! Besides, SHE'S she, and I'm I, and--oh dear, how puzzling\n"
."it all is! I'll try if I know all the things I used to know. Let me\n"
."see: four times five is twelve, and four times six is thirteen, and\n"
."four times seven is--oh dear! I shall never get to twenty at that rate!\n"
."However, the Multiplication Table doesn't signify: let's try Geography.\n"
."London is the capital of Paris, and Paris is the capital of Rome, and\n"
."Rome--no, THAT'S all wrong, I'm certain! I must have been changed for\n"
."Mabel! I'll try and say \"How doth the little--\"' and she crossed her\n"
."hands on her lap as if she were saying lessons, and began to repeat it,\n"
."but her voice sounded hoarse and strange, and the words did not come the\n"
."same as they used to do:--\n"
."\n"
."     'How doth the little crocodile\n"
."      Improve his shining tail,\n"
."     And pour the waters of the Nile\n"
."      On every golden scale!\n"
."\n"
."     'How cheerfully he seems to grin,\n"
."      How neatly spread his claws,\n"
."     And welcome little fishes in\n"
."      With gently smiling jaws!'\n"
."\n"
."'I'm sure those are not the right words,' said poor Alice, and her eyes\n"
."filled with tears again as she went on, 'I must be Mabel after all, and\n"
."I shall have to go and live in that poky little house, and have next to\n"
."no toys to play with, and oh! ever so many lessons to learn! No, I've\n"
."made up my mind about it; if I'm Mabel, I'll stay down here! It'll be no\n"
."use their putting their heads down and saying \"Come up again, dear!\" I\n"
."shall only look up and say \"Who am I then? Tell me that first, and then,\n"
."if I like being that person, I'll come up: if not, I'll stay down here\n"
."till I'm somebody else\"--but, oh dear!' cried Alice, with a sudden burst\n"
."of tears, 'I do wish they WOULD put their heads down! I am so VERY tired\n"
."of being all alone here!'\n"
."\n"
."As she said this she looked down at her hands, and was surprised to see\n"
."that she had put on one of the Rabbit's little white kid gloves while\n"
."she was talking. 'How CAN I have done that?' she thought. 'I must\n"
."be growing small again.' She got up and went to the table to measure\n"
."herself by it, and found that, as nearly as she could guess, she was now\n"
."about two feet high, and was going on shrinking rapidly: she soon found\n"
."out that the cause of this was the fan she was holding, and she dropped\n"
."it hastily, just in time to avoid shrinking away altogether.\n"
."\n"
."'That WAS a narrow escape!' said Alice, a good deal frightened at the\n"
."sudden change, but very glad to find herself still in existence; 'and\n"
."now for the garden!' and she ran with all speed back to the little door:\n"
."but, alas! the little door was shut again, and the little golden key was\n"
."lying on the glass table as before, 'and things are worse than ever,'\n"
."thought the poor child, 'for I never was so small as this before, never!\n"
."And I declare it's too bad, that it is!'\n"
."\n"
."As she said these words her foot slipped, and in another moment, splash!\n"
."she was up to her chin in salt water. Her first idea was that she\n"
."had somehow fallen into the sea, 'and in that case I can go back by\n"
."railway,' she said to herself. (Alice had been to the seaside once in\n"
."her life, and had come to the general conclusion, that wherever you go\n"
."to on the English coast you find a number of bathing machines in the\n"
."sea, some children digging in the sand with wooden spades, then a row\n"
."of lodging houses, and behind them a railway station.) However, she soon\n"
."made out that she was in the pool of tears which she had wept when she\n"
."was nine feet high.\n"
."\n"
."'I wish I hadn't cried so much!' said Alice, as she swam about, trying\n"
."to find her way out. 'I shall be punished for it now, I suppose, by\n"
."being drowned in my own tears! That WILL be a queer thing, to be sure!\n"
."However, everything is queer to-day.'\n"
."\n"
."Just then she heard something splashing about in the pool a little way\n"
."off, and she swam nearer to make out what it was: at first she thought\n"
."it must be a walrus or hippopotamus, but then she remembered how small\n"
."she was now, and she soon made out that it was only a mouse that had\n"
."slipped in like herself.\n"
."\n"
."'Would it be of any use, now,' thought Alice, 'to speak to this mouse?\n"
."Everything is so out-of-the-way down here, that I should think very\n"
."likely it can talk: at any rate, there's no harm in trying.' So she\n"
."began: 'O Mouse, do you know the way out of this pool? I am very tired\n"
."of swimming about here, O Mouse!' (Alice thought this must be the right\n"
."way of speaking to a mouse: she had never done such a thing before, but\n"
."she remembered having seen in her brother's Latin Grammar, 'A mouse--of\n"
."a mouse--to a mouse--a mouse--O mouse!') The Mouse looked at her rather\n"
."inquisitively, and seemed to her to wink with one of its little eyes,\n"
."but it said nothing.\n"
."\n"
."'Perhaps it doesn't understand English,' thought Alice; 'I daresay it's\n"
."a French mouse, come over with William the Conqueror.' (For, with all\n"
."her knowledge of history, Alice had no very clear notion how long ago\n"
."anything had happened.) So she began again: 'Ou est ma chatte?' which\n"
."was the first sentence in her French lesson-book. The Mouse gave a\n"
."sudden leap out of the water, and seemed to quiver all over with fright.\n"
."'Oh, I beg your pardon!' cried Alice hastily, afraid that she had hurt\n"
."the poor animal's feelings. 'I quite forgot you didn't like cats.'\n"
."\n"
."'Not like cats!' cried the Mouse, in a shrill, passionate voice. 'Would\n"
."YOU like cats if you were me?'\n"
."\n"
."'Well, perhaps not,' said Alice in a soothing tone: 'don't be angry\n"
."about it. And yet I wish I could show you our cat Dinah: I think you'd\n"
."take a fancy to cats if you could only see her. She is such a dear quiet\n"
."thing,' Alice went on, half to herself, as she swam lazily about in the\n"
."pool, 'and she sits purring so nicely by the fire, licking her paws and\n"
."washing her face--and she is such a nice soft thing to nurse--and she's\n"
."such a capital one for catching mice--oh, I beg your pardon!' cried\n"
."Alice again, for this time the Mouse was bristling all over, and she\n"
."felt certain it must be really offended. 'We won't talk about her any\n"
."more if you'd rather not.'\n"
."\n"
."'We indeed!' cried the Mouse, who was trembling down to the end of his\n"
."tail. 'As if I would talk on such a subject! Our family always HATED\n"
."cats: nasty, low, vulgar things! Don't let me hear the name again!'\n"
."\n"
."'I won't indeed!' said Alice, in a great hurry to change the subject of\n"
."conversation. 'Are you--are you fond--of--of dogs?' The Mouse did not\n"
."answer, so Alice went on eagerly: 'There is such a nice little dog near\n"
."our house I should like to show you! A little bright-eyed terrier, you\n"
."know, with oh, such long curly brown hair! And it'll fetch things when\n"
."you throw them, and it'll sit up and beg for its dinner, and all sorts\n"
."of things--I can't remember half of them--and it belongs to a farmer,\n"
."you know, and he says it's so useful, it's worth a hundred pounds! He\n"
."says it kills all the rats and--oh dear!' cried Alice in a sorrowful\n"
."tone, 'I'm afraid I've offended it again!' For the Mouse was swimming\n"
."away from her as hard as it could go, and making quite a commotion in\n"
."the pool as it went.\n"
."\n"
."So she called softly after it, 'Mouse dear! Do come back again, and we\n"
."won't talk about cats or dogs either, if you don't like them!' When the\n"
."Mouse heard this, it turned round and swam slowly back to her: its\n"
."face was quite pale (with passion, Alice thought), and it said in a low\n"
."trembling voice, 'Let us get to the shore, and then I'll tell you my\n"
."history, and you'll understand why it is I hate cats and dogs.'\n"
."\n"
."It was high time to go, for the pool was getting quite crowded with the\n"
."birds and animals that had fallen into it: there were a Duck and a Dodo,\n"
."a Lory and an Eaglet, and several other curious creatures. Alice led the\n"
."way, and the whole party swam to the shore.\n";
}

sub Hound { return "The Hound of the Baskervilles\n"
."\n"
."by A. Conan Doyle\n"
."\n"
."\n"
."\n"
."\n"
."Chapter 1\n"
."Mr. Sherlock Holmes\n"
."\n"
."\n"
."\n"
."Mr. Sherlock Holmes, who was usually very late in the mornings,\n"
."save upon those not infrequent occasions when he was up all night,\n"
."was seated at the breakfast table.  I stood upon the hearth-rug\n"
."and picked up the stick which our visitor had left behind him the\n"
."night before.  It was a fine, thick piece of wood, bulbous-headed,\n"
."of the sort which is known as a \"Penang lawyer.\"  Just under the\n"
."head was a broad silver band nearly an inch across.  \"To James\n"
."Mortimer, M.R.C.S., from his friends of the C.C.H.,\" was engraved\n"
."upon it, with the date \"1884.\"  It was just such a stick as the\n"
."old-fashioned family practitioner used to carry--dignified, solid,\n"
."and reassuring.\n"
."\n"
."\"Well, Watson, what do you make of it?\"\n"
."\n"
."Holmes was sitting with his back to me, and I had given him no\n"
."sign of my occupation.\n"
."\n"
."\"How did you know what I was doing?  I believe you have eyes in\n"
."the back of your head.\"\n"
."\n"
."\"I have, at least, a well-polished, silver-plated coffee-pot in\n"
."front of me,\" said he.  \"But, tell me, Watson, what do you make\n"
."of our visitor's stick?  Since we have been so unfortunate as to\n"
."miss him and have no notion of his errand, this accidental souvenir\n"
."becomes of importance.  Let me hear you reconstruct the man by an\n"
."examination of it.\"\n"
."\n"
."\"I think,\" said I, following as far as I could the methods of my\n"
."companion, \"that Dr. Mortimer is a successful, elderly medical\n"
."man, well-esteemed since those who know him give him this mark\n"
."of their appreciation.\"\n"
."\n"
."\"Good!\" said Holmes.  \"Excellent!\"\n"
."\n"
."\"I think also that the probability is in favour of his being a\n"
."country practitioner who does a great deal of his visiting on foot.\"\n"
."\n"
."\"Why so?\"\n"
."\n"
."\"Because this stick, though originally a very handsome one has been\n"
."so knocked about that I can hardly imagine a town practitioner\n"
."carrying it.  The thick-iron ferrule is worn down, so it is evident\n"
."that he has done a great amount of walking with it.\"\n"
."\n"
."\"Perfectly sound!\" said Holmes.\n"
."\n"
."\"And then again, there is the 'friends of the C.C.H.'  I should\n"
."guess that to be the Something Hunt, the local hunt to whose\n"
."members he has possibly given some surgical assistance, and which\n"
."has made him a small presentation in return.\"\n"
."\n"
."\"Really, Watson, you excel yourself,\" said Holmes, pushing back\n"
."his chair and lighting a cigarette.  \"I am bound to say that in\n"
."all the accounts which you have been so good as to give of my\n"
."own small achievements you have habitually underrated your own\n"
."abilities.  It may be that you are not yourself luminous, but\n"
."you are a conductor of light.  Some people without possessing\n"
."genius have a remarkable power of stimulating it.  I confess, my\n"
."dear fellow, that I am very much in your debt.\"\n"
."\n"
."He had never said as much before, and I must admit that his words\n"
."gave me keen pleasure, for I had often been piqued by his\n"
."indifference to my admiration and to the attempts which I had\n"
."made to give publicity to his methods.  I was proud, too, to\n"
."think that I had so far mastered his system as to apply it in a\n"
."way which earned his approval.  He now took the stick from my\n"
."hands and examined it for a few minutes with his naked eyes.\n"
."Then with an expression of interest he laid down his cigarette,\n"
."and carrying the cane to the window, he looked over it again with\n"
."a convex lens.\n"
."\n"
."\"Interesting, though elementary,\" said he as he returned to his\n"
."favourite corner of the settee.  \"There are certainly one or two\n"
."indications upon the stick.  It gives us the basis for several\n"
."deductions.\"\n"
."\n"
."\"Has anything escaped me?\"  I asked with some self-importance.\n"
."\"I trust that there is nothing of consequence which I have\n"
."overlooked?\"\n"
."\n"
."\"I am afraid, my dear Watson, that most of your conclusions were\n"
."erroneous.  When I said that you stimulated me I meant, to be\n"
."frank, that in noting your fallacies I was occasionally guided\n"
."towards the truth.  Not that you are entirely wrong in this\n"
."instance.  The man is certainly a country practitioner.  And he\n"
."walks a good deal.\"\n"
."\n"
."\"Then I was right.\"\n"
."\n"
."\"To that extent.\"\n"
."\n"
."\"But that was all.\"\n"
."\n"
."\"No, no, my dear Watson, not all--by no means all.  I would\n"
."suggest, for example, that a presentation to a doctor is more\n"
."likely to come from a hospital than from a hunt, and that when\n"
."the initials 'C.C.' are placed before that hospital the words\n"
."'Charing Cross' very naturally suggest themselves.\"\n"
."\n"
."\"You may be right.\"\n"
."\n"
."\"The probability lies in that direction.  And if we take this as\n"
."a working hypothesis we have a fresh basis from which to start\n"
."our construction of this unknown visitor.\"\n"
."\n"
."\"Well, then, supposing that 'C.C.H.' does stand for 'Charing Cross\n"
."Hospital,' what further inferences may we draw?\"\n"
."\n"
."\"Do none suggest themselves?  You know my methods.  Apply them!\"\n"
."\n"
."\"I can only think of the obvious conclusion that the man has\n"
."practised in town before going to the country.\"\n"
."\n"
."\"I think that we might venture a little farther than this.  Look\n"
."at it in this light.  On what occasion would it be most probable\n"
."that such a presentation would be made?  When would his friends\n"
."unite to give him a pledge of their good will?  Obviously at the\n"
."moment when Dr. Mortimer withdrew from the service of the hospital\n"
."in order to start a practice for himself.  We know there has been\n"
."a presentation.  We believe there has been a change from a town\n"
."hospital to a country practice.  Is it, then, stretching our\n"
."inference too far to say that the presentation was on the occasion\n"
."of the change?\"\n"
."\n"
."\"It certainly seems probable.\"\n"
."\n"
."\"Now, you will observe that he could not have been on the staff\n"
."of the hospital, since only a man well-established in a London\n"
."practice could hold such a position, and such a one would not\n"
."drift into the country.  What was he, then?  If he was in the\n"
."hospital and yet not on the staff he could only have been a\n"
."house-surgeon or a house-physician--little more than a senior\n"
."student.  And he left five years ago--the date is on the stick.\n"
."So your grave, middle-aged family practitioner vanishes into thin\n"
."air, my dear Watson, and there emerges a young fellow under thirty,\n"
."amiable, unambitious, absent-minded, and the possessor of a\n"
."favourite dog, which I should describe roughly as being larger\n"
."than a terrier and smaller than a mastiff.\"\n"
."\n"
."I laughed incredulously as Sherlock Holmes leaned back in his\n"
."settee and blew little wavering rings of smoke up to the ceiling.\n"
."\n"
."\"As to the latter part, I have no means of checking you,\" said I,\n"
."\"but at least it is not difficult to find out a few particulars\n"
."about the man's age and professional career.\"  From my small\n"
."medical shelf I took down the Medical Directory and turned up\n"
."the name.  There were several Mortimers, but only one who could\n"
."be our visitor.  I read his record aloud.\n"
."\n"
."        \"Mortimer, James, M.R.C.S., 1882, Grimpen, Dartmoor, Devon.\n"
."        House-surgeon, from 1882 to 1884, at Charing Cross Hospital.\n"
."        Winner of the Jackson prize for Comparative Pathology,\n"
."        with essay entitled 'Is Disease a Reversion?'  Corresponding\n"
."        member of the Swedish Pathological Society.  Author of\n"
."        'Some Freaks of Atavism' (Lancet 1882).  'Do We Progress?'\n"
."        (Journal of Psychology, March, 1883).  Medical Officer\n"
."        for the parishes of Grimpen, Thorsley, and High Barrow.\"\n"
."\n"
."\"No mention of that local hunt, Watson,\" said Holmes with a\n"
."mischievous smile, \"but a country doctor, as you very astutely\n"
."observed.  I think that I am fairly justified in my inferences.\n"
."As to the adjectives, I said, if I remember right, amiable,\n"
."unambitious, and absent-minded.  It is my experience that it is\n"
."only an amiable man in this world who receives testimonials, only\n"
."an unambitious one who abandons a London career for the country,\n"
."and only an absent-minded one who leaves his stick and not his\n"
."visiting-card after waiting an hour in your room.\"\n"
."\n"
."\"And the dog?\"\n"
."\n"
."\"Has been in the habit of carrying this stick behind his master.\n"
."Being a heavy stick the dog has held it tightly by the middle,\n"
."and the marks of his teeth are very plainly visible.  The dog's\n"
."jaw, as shown in the space between these marks, is too broad in\n"
."my opinion for a terrier and not broad enough for a mastiff.  It\n"
."may have been--yes, by Jove, it is a curly-haired spaniel.\"\n"
."\n"
."He had risen and paced the room as he spoke.  Now he halted in\n"
."the recess of the window.  There was such a ring of conviction\n"
."in his voice that I glanced up in surprise.\n"
."\n"
."\"My dear fellow, how can you possibly be so sure of that?\"\n"
."\n"
."\"For the very simple reason that I see the dog himself on our\n"
."very door-step, and there is the ring of its owner.  Don't move,\n"
."I beg you, Watson.  He is a professional brother of yours, and\n"
."your presence may be of assistance to me.  Now is the dramatic\n"
."moment of fate, Watson, when you hear a step upon the stair which\n"
."is walking into your life, and you know not whether for good or\n"
."ill.  What does Dr. James Mortimer, the man of science, ask of\n"
."Sherlock Holmes, the specialist in crime?  Come in!\"\n"
."\n"
."The appearance of our visitor was a surprise to me, since I had\n"
."expected a typical country practitioner.  He was a very tall,\n"
."thin man, with a long nose like a beak, which jutted out between\n"
."two keen, gray eyes, set closely together and sparkling brightly\n"
."from behind a pair of gold-rimmed glasses.  He was clad in a\n"
."professional but rather slovenly fashion, for his frock-coat was\n"
."dingy and his trousers frayed.  Though young, his long back was\n"
."already bowed, and he walked with a forward thrust of his head\n"
."and a general air of peering benevolence.  As he entered his eyes\n"
."fell upon the stick in Holmes's hand, and he ran towards it with\n"
."an exclamation of joy.  \"I am so very glad,\" said he.  \"I was not\n"
."sure whether I had left it here or in the Shipping Office.  I\n"
."would not lose that stick for the world.\"\n"
."\n"
."\"A presentation, I see,\" said Holmes.\n"
."\n"
."\"Yes, sir.\"\n"
."\n"
."\"From Charing Cross Hospital?\"\n"
."\n"
."\"From one or two friends there on the occasion of my marriage.\"\n"
."\n"
."\"Dear, dear, that's bad!\" said Holmes, shaking his head.\n"
."\n"
."Dr. Mortimer blinked through his glasses in mild astonishment.\n"
."\"Why was it bad?\"\n"
."\n"
."\"Only that you have disarranged our little deductions.  Your\n"
."marriage, you say?\"\n"
."\n"
."\"Yes, sir.  I married, and so left the hospital, and with it all\n"
."hopes of a consulting practice.  It was necessary to make a home\n"
."of my own.\"\n"
."\n"
."\"Come, come, we are not so far wrong, after all,\" said Holmes.\n"
."\"And now, Dr. James Mortimer--\"\n"
."\n"
."\"Mister, sir, Mister--a humble M.R.C.S.\"\n"
."\n"
."\"And a man of precise mind, evidently.\"\n"
."\n"
."\"A dabbler in science, Mr. Holmes, a picker up of shells on the\n"
."shores of the great unknown ocean.  I presume that it is\n"
."Mr. Sherlock Holmes whom I am addressing and not--\"\n"
."\n"
."\"No, this is my friend Dr. Watson.\"\n"
."\n"
."\"Glad to meet you, sir.  I have heard your name mentioned in\n"
."connection with that of your friend.  You interest me very much,\n"
."Mr. Holmes.  I had hardly expected so dolichocephalic a skull or\n"
."such well-marked supra-orbital development.  Would you have any\n"
."objection to my running my finger along your parietal fissure?\n"
."A cast of your skull, sir, until the original is available, would\n"
."be an ornament to any anthropological museum.  It is not my\n"
."intention to be fulsome, but I confess that I covet your skull.\"\n"
."\n"
."Sherlock Holmes waved our strange visitor into a chair.  \"You are\n"
."an enthusiast in your line of thought, I perceive, sir, as I am\n"
."in mine,\" said he.  \"I observe from your forefinger that you make\n"
."your own cigarettes.  Have no hesitation in lighting one.\"\n"
."\n"
."The man drew out paper and tobacco and twirled the one up in the\n"
."other with surprising dexterity.  He had long, quivering fingers\n"
."as agile and restless as the antennae of an insect.\n"
."\n"
."Holmes was silent, but his little darting glances showed me the\n"
."interest which he took in our curious companion.  \"I presume, sir,\"\n"
."said he at last, \"that it was not merely for the purpose of\n"
."examining my skull that you have done me the honour to call here\n"
."last night and again today?\"\n"
."\n"
."\"No, sir, no; though I am happy to have had the opportunity of\n"
."doing that as well.  I came to you, Mr. Holmes, because I recognized\n"
."that I am myself an unpractical man and because I am suddenly\n"
."confronted with a most serious and extraordinary problem.\n"
."Recognizing, as I do, that you are the second highest expert in\n"
."Europe--\"\n"
."\n"
."\"Indeed, sir!  May I inquire who has the honour to be the first?\"\n"
."asked Holmes with some asperity.\n"
."\n"
."\"To the man of precisely scientific mind the work of Monsieur\n"
."Bertillon must always appeal strongly.\"\n"
."\n"
."\"Then had you not better consult him?\"\n"
."\n"
."\"I said, sir, to the precisely scientific mind.  But as a practical\n"
."man of affairs it is acknowledged that you stand alone.  I trust,\n"
."sir, that I have not inadvertently--\"\n"
."\n"
."\"Just a little,\" said Holmes.  \"I think, Dr. Mortimer, you would\n"
."do wisely if without more ado you would kindly tell me plainly\n"
."what the exact nature of the problem is in which you demand my\n"
."assistance.\"\n"
."\n"
."\n"
."\n"
."\n"
."Chapter 2\n"
."The Curse of the Baskervilles\n"
."\n"
."\n"
."\n"
."\"I have in my pocket a manuscript,\" said Dr. James Mortimer.\n"
."\n"
."\"I observed it as you entered the room,\" said Holmes.\n"
."\n"
."\"It is an old manuscript.\"\n"
."\n"
."\"Early eighteenth century, unless it is a forgery.\"\n"
."\n"
."\"How can you say that, sir?\"\n"
."\n"
."\"You have presented an inch or two of it to my examination all\n"
."the time that you have been talking.  It would be a poor expert\n"
."who could not give the date of a document within a decade or so.\n"
."You may possibly have read my little monograph upon the subject.\n"
."I put that at 1730.\"\n"
."\n"
."\"The exact date is 1742.\"  Dr. Mortimer drew it from his breast-\n"
."pocket.  \"This family paper was committed to my care by Sir Charles\n"
."Baskerville, whose sudden and tragic death some three months ago\n"
."created so much excitement in Devonshire.  I may say that I was\n"
."his personal friend as well as his medical attendant.  He was a\n"
."strong-minded man, sir, shrewd, practical, and as unimaginative\n"
."as I am myself.  Yet he took this document very seriously, and\n"
."his mind was prepared for just such an end as did eventually\n"
."overtake him.\"\n"
."\n"
."Holmes stretched out his hand for the manuscript and flattened it\n"
."upon his knee.  \"You will observe, Watson, the alternative use of\n"
."the long s and the short.  It is one of several indications which\n"
."enabled me to fix the date.\"\n"
."\n"
."I looked over his shoulder at the yellow paper and the faded script.\n"
."At the head was written: \"Baskerville Hall,\" and below in large,\n"
."scrawling figures: \"1742.\"\n"
."\n"
."\"It appears to be a statement of some sort.\"\n"
."\n"
."\"Yes, it is a statement of a certain legend which runs in the\n"
."Baskerville family.\"\n"
."\n"
."\"But I understand that it is something more modern and practical\n"
."upon which you wish to consult me?\"\n"
."\n"
."\"Most modern.  A most practical, pressing matter, which must be\n"
."decided within twenty-four hours.  But the manuscript is short\n"
."and is intimately connected with the affair.  With your permission\n"
."I will read it to you.\"\n"
."\n"
."Holmes leaned back in his chair, placed his finger-tips together,\n"
."and closed his eyes, with an air of resignation.  Dr. Mortimer\n"
."turned the manuscript to the light and read in a high, cracking\n"
."voice the following curious, old-world narrative:\n"
."\n"
."        \"Of the origin of the Hound of the Baskervilles there\n"
."        have been many statements, yet as I come in a direct\n"
."        line from Hugo Baskerville, and as I had the story from\n"
."        my father, who also had it from his, I have set it down\n"
."        with all belief that it occurred even as is here set\n"
."        forth.  And I would have you believe, my sons, that the\n"
."        same Justice which punishes sin may also most graciously\n"
."        forgive it, and that no ban is so heavy but that by prayer\n"
."        and repentance it may be removed.  Learn then from this\n"
."        story not to fear the fruits of the past, but rather to\n"
."        be circumspect in the future, that those foul passions\n"
."        whereby our family has suffered so grievously may not\n"
."        again be loosed to our undoing.\n"
."\n"
."        \"Know then that in the time of the Great Rebellion (the\n"
."        history of which by the learned Lord Clarendon I most\n"
."        earnestly commend to your attention) this Manor of\n"
."        Baskerville was held by Hugo of that name, nor can it be\n"
."        gainsaid that he was a most wild, profane, and godless\n"
."        man.  This, in truth, his neighbours might have pardoned,\n"
."        seeing that saints have never flourished in those parts,\n"
."        but there was in him a certain wanton and cruel humour\n"
."        which made his name a by-word through the West.  It\n"
."        chanced that this Hugo came to love (if, indeed, so dark\n"
."        a passion may be known under so bright a name) the daughter\n"
."        of a yeoman who held lands near the Baskerville estate.\n"
."        But the young maiden, being discreet and of good repute,\n"
."        would ever avoid him, for she feared his evil name.  So\n"
."        it came to pass that one Michaelmas this Hugo, with five\n"
."        or six of his idle and wicked companions, stole down upon\n"
."        the farm and carried off the maiden, her father and\n"
."        brothers being from home, as he well knew.  When they had\n"
."        brought her to the Hall the maiden was placed in an upper\n"
."        chamber, while Hugo and his friends sat down to a long\n"
."        carouse, as was their nightly custom.  Now, the poor lass\n"
."        upstairs was like to have her wits turned at the singing\n"
."        and shouting and terrible oaths which came up to her from\n"
."        below, for they say that the words used by Hugo Baskerville,\n"
."        when he was in wine, were such as might blast the man who\n"
."        said them.  At last in the stress of her fear she did that\n"
."        which might have daunted the bravest or most active man,\n"
."        for by the aid of the growth of ivy which covered (and\n"
."        still covers) the south wall she came down from under the\n"
."        eaves, and so homeward across the moor, there being three\n"
."        leagues betwixt the Hall and her father's farm.\n"
."\n"
."        \"It chanced that some little time later Hugo left his\n"
."        guests to carry food and drink--with other worse things,\n"
."        perchance--to his captive, and so found the cage empty\n"
."        and the bird escaped.  Then, as it would seem, he became\n"
."        as one that hath a devil, for, rushing down the stairs\n"
."        into the dining-hall, he sprang upon the great table,\n"
."        flagons and trenchers flying before him, and he cried\n"
."        aloud before all the company that he would that very\n"
."        night render his body and soul to the Powers of Evil if\n"
."        he might but overtake the wench.  And while the revellers\n"
."        stood aghast at the fury of the man, one more wicked or,\n"
."        it may be, more drunken than the rest, cried out that\n"
."        they should put the hounds upon her.  Whereat Hugo ran\n"
."        from the house, crying to his grooms that they should\n"
."        saddle his mare and unkennel the pack, and giving the\n"
."        hounds a kerchief of the maid's, he swung them to the\n"
."        line, and so off full cry in the moonlight over the moor.\n"
."\n"
."        \"Now, for some space the revellers stood agape, unable\n"
."        to understand all that had been done in such haste.  But\n"
."        anon their bemused wits awoke to the nature of the deed\n"
."        which was like to be done upon the moorlands.  Everything\n"
."        was now in an uproar, some calling for their pistols,\n"
."        some for their horses, and some for another flask of\n"
."        wine.  But at length some sense came back to their crazed\n"
."        minds, and the whole of them, thirteen in number, took\n"
."        horse and started in pursuit.  The moon shone clear above\n"
."        them, and they rode swiftly abreast, taking that course\n"
."        which the maid must needs have taken if she were to reach\n"
."        her own home.\n"
."\n"
."        \"They had gone a mile or two when they passed one of the\n"
."        night shepherds upon the moorlands, and they cried to\n"
."        him to know if he had seen the hunt.  And the man, as\n"
."        the story goes, was so crazed with fear that he could\n"
."        scarce speak, but at last he said that he had indeed seen\n"
."        the unhappy maiden, with the hounds upon her track.  'But\n"
."        I have seen more than that,' said he, 'for Hugo Baskerville\n"
."        passed me upon his black mare, and there ran mute behind\n"
."        him such a hound of hell as God forbid should ever be at\n"
."        my heels.'  So the drunken squires cursed the shepherd\n"
."        and rode onward.  But soon their skins turned cold, for\n"
."        there came a galloping across the moor, and the black\n"
."        mare, dabbled with white froth, went past with trailing\n"
."        bridle and empty saddle.  Then the revellers rode close\n"
."        together, for a great fear was on them, but they still\n"
."        followed over the moor, though each, had he been alone,\n"
."        would have been right glad to have turned his horse's\n"
."        head.  Riding slowly in this fashion they came at last\n"
."        upon the hounds.  These, though known for their valour\n"
."        and their breed, were whimpering in a cluster at the\n"
."        head of a deep dip or goyal, as we call it, upon the\n"
."        moor, some slinking away and some, with starting hackles\n"
."        and staring eyes, gazing down the narrow valley before them.\n"
."\n"
."        \"The company had come to a halt, more sober men, as you\n"
."        may guess, than when they started.  The most of them\n"
."        would by no means advance, but three of them, the boldest,\n"
."        or it may be the most drunken, rode forward down the goyal.\n"
."        Now, it opened into a broad space in which stood two of\n"
."        those great stones, still to be seen there, which were\n"
."        set by certain forgotten peoples in the days of old.\n"
."        The moon was shining bright upon the clearing, and there\n"
."        in the centre lay the unhappy maid where she had fallen,\n"
."        dead of fear and of fatigue.  But it was not the sight\n"
."        of her body, nor yet was it that of the body of Hugo\n"
."        Baskerville lying near her, which raised the hair upon\n"
."        the heads of these three dare-devil roysterers, but it\n"
."        was that, standing over Hugo, and plucking at his throat,\n"
."        there stood a foul thing, a great, black beast, shaped\n"
."        like a hound, yet larger than any hound that ever mortal\n"
."        eye has rested upon.  And even as they looked the thing\n"
."        tore the throat out of Hugo Baskerville, on which, as it\n"
."        turned its blazing eyes and dripping jaws upon them, the\n"
."        three shrieked with fear and rode for dear life, still\n"
."        screaming, across the moor.  One, it is said, died that\n"
."        very night of what he had seen, and the other twain were\n"
."        but broken men for the rest of their days.\n"
."\n"
."        \"Such is the tale, my sons, of the coming of the hound\n"
."        which is said to have plagued the family so sorely ever\n"
."        since.  If I have set it down it is because that which\n"
."        is clearly known hath less terror than that which is but\n"
."        hinted at and guessed.  Nor can it be denied that many\n"
."        of the family have been unhappy in their deaths, which\n"
."        have been sudden, bloody, and mysterious.  Yet may we\n"
."        shelter ourselves in the infinite goodness of Providence,\n"
."        which would not forever punish the innocent beyond that\n"
."        third or fourth generation which is threatened in Holy\n"
."        Writ.  To that Providence, my sons, I hereby commend\n"
."        you, and I counsel you by way of caution to forbear from\n"
."        crossing the moor in those dark hours when the powers of\n"
."        evil are exalted.\n";
}

sub Macbeth { return "\n"
."\n"
."ACT IV.\n"
."\n"
."SCENE I. A dark Cave. In the middle, a Caldron Boiling.\n"
."\n"
."[Thunder. Enter the three Witches.]\n"
."\n"
."FIRST WITCH.\n"
."Thrice the brinded cat hath mew'd.\n"
."\n"
."SECOND WITCH.\n"
."Thrice; and once the hedge-pig whin'd.\n"
."\n"
."THIRD WITCH.\n"
."Harpier cries:--\"tis time, 'tis time.\n"
."\n"
."FIRST WITCH.\n"
."Round about the caldron go;\n"
."In the poison'd entrails throw.--\n"
."Toad, that under cold stone,\n"
."Days and nights has thirty-one\n"
."Swelter'd venom sleeping got,\n"
."Boil thou first i' the charmed pot!\n"
."\n"
."ALL.\n"
."Double, double, toil and trouble;\n"
."Fire, burn; and caldron, bubble.\n"
."\n"
."SECOND WITCH.\n"
."Fillet of a fenny snake,\n"
."In the caldron boil and bake;\n"
."Eye of newt, and toe of frog,\n"
."Wool of bat, and tongue of dog,\n"
."Adder's fork, and blind-worm's sting,\n"
."Lizard's leg, and howlet's wing,--\n"
."For a charm of powerful trouble,\n"
."Like a hell-broth boil and bubble.\n"
."\n"
."ALL.\n"
."Double, double, toil and trouble;\n"
."Fire, burn; and caldron, bubble.\n"
."\n"
."THIRD WITCH.\n"
."Scale of dragon, tooth of wolf,\n"
."Witch's mummy, maw and gulf\n"
."Of the ravin'd salt-sea shark,\n"
."Root of hemlock digg'd i' the dark,\n"
."Liver of blaspheming Jew,\n"
."Gall of goat, and slips of yew\n"
."Sliver'd in the moon's eclipse,\n"
."Nose of Turk, and Tartar's lips,\n"
."Finger of birth-strangl'd babe\n"
."Ditch-deliver'd by a drab,--\n"
."Make the gruel thick and slab:\n"
."Add thereto a tiger's chaudron,\n"
."For the ingredients of our caldron.\n"
."\n"
."ALL.\n"
."Double, double, toil and trouble;\n"
."Fire, burn; and caldron, bubble.\n"
."\n"
."SECOND WITCH.\n"
."Cool it with a baboon's blood,\n"
."Then the charm is firm and good.\n"
."\n"
."[Enter Hecate.]\n"
."\n"
."HECATE.\n"
."O, well done! I commend your pains;\n"
."And everyone shall share i' the gains.\n"
."And now about the cauldron sing,\n"
."Like elves and fairies in a ring,\n"
."Enchanting all that you put in.\n"
."\n"
."Song.\n"
."Black spirits and white, red spirits and gray;\n"
."Mingle, mingle, mingle, you that mingle may.\n"
."\n"
."[Exit Hecate.]\n"
."\n"
."SECOND WITCH.\n"
."By the pricking of my thumbs,\n"
."Something wicked this way comes:--\n"
."Open, locks, whoever knocks!\n"
."\n"
."[Enter Macbeth.]\n"
."\n"
."MACBETH.\n"
."How now, you secret, black, and midnight hags!\n"
."What is't you do?\n"
."\n"
."ALL.\n"
."A deed without a name.\n"
."\n"
."MACBETH.\n"
."I conjure you, by that which you profess,--\n"
."Howe'er you come to know it,--answer me:\n"
."Though you untie the winds, and let them fight\n"
."Against the churches; though the yesty waves\n"
."Confound and swallow navigation up;\n"
."Though bladed corn be lodg'd, and trees blown down;\n"
."Though castles topple on their warders' heads;\n"
."Though palaces and pyramids do slope\n"
."Their heads to their foundations; though the treasure\n"
."Of nature's germins tumble all together,\n"
."Even till destruction sicken,--answer me\n"
."To what I ask you.\n"
."\n"
."FIRST WITCH.\n"
."Speak.\n"
."\n"
."SECOND WITCH.\n"
."Demand.\n"
."\n"
."THIRD WITCH.\n"
."We'll answer.\n"
."\n"
."FIRST WITCH.\n"
."Say, if thou'dst rather hear it from our mouths,\n"
."Or from our masters?\n"
."\n"
."MACBETH.\n"
."Call 'em, let me see 'em.\n"
."\n"
."FIRST WITCH.\n"
."Pour in sow's blood, that hath eaten\n"
."Her nine farrow; grease that's sweaten\n"
."From the murderer's gibbet throw\n"
."Into the flame.\n"
."\n"
."ALL.\n"
."Come, high or low;\n"
."Thyself and office deftly show!\n"
."\n"
."[Thunder. An Apparition of an armed Head rises.]\n"
."\n"
."MACBETH.\n"
."Tell me, thou unknown power,--\n"
."\n"
."FIRST WITCH.\n"
."He knows thy thought:\n"
."Hear his speech, but say thou naught.\n"
."\n"
."APPARITION.\n"
."Macbeth! Macbeth! Macbeth! Beware Macduff;\n"
."Beware the Thane of Fife.--Dismiss me:--enough.\n"
."\n"
."[Descends.]\n"
."\n"
."MACBETH.\n"
."Whate'er thou art, for thy good caution, thanks;\n"
."Thou hast harp'd my fear aright:--but one word more,--\n"
."\n"
."FIRST WITCH.\n"
."He will not be commanded: here's another,\n"
."More potent than the first.\n"
."\n"
."[Thunder. An Apparition of a bloody Child rises.]\n"
."\n"
."APPARITION.--\n"
."Macbeth! Macbeth! Macbeth!\n"
."\n"
."MACBETH.\n"
."Had I three ears, I'd hear thee.\n"
."\n"
."APPARITION.\n"
."Be bloody, bold, and resolute; laugh to scorn\n"
."The power of man, for none of woman born\n"
."Shall harm Macbeth.\n"
."\n"
."[Descends.]\n"
."\n"
."MACBETH.\n"
."Then live, Macduff: what need I fear of thee?\n"
."But yet I'll make assurance double sure,\n"
."And take a bond of fate: thou shalt not live;\n"
."That I may tell pale-hearted fear it lies,\n"
."And sleep in spite of thunder.--What is this,\n"
."\n"
."[Thunder. An Apparition of a Child crowned, with a tree in his\n"
."hand, rises.]\n"
."\n"
."That rises like the issue of a king,\n"
."And wears upon his baby brow the round\n"
."And top of sovereignty?\n"
."\n"
."ALL.\n"
."Listen, but speak not to't.\n"
."\n"
."APPARITION.\n"
."Be lion-mettled, proud; and take no care\n"
."Who chafes, who frets, or where conspirers are:\n"
."Macbeth shall never vanquish'd be, until\n"
."Great Birnam wood to high Dunsinane hill\n"
."Shall come against him.\n"
."\n"
."[Descends.]\n"
."\n"
."MACBETH.\n"
."That will never be:\n"
."Who can impress the forest; bid the tree\n"
."Unfix his earth-bound root? Sweet bodements, good!\n"
."Rebellion's head, rise never till the wood\n"
."Of Birnam rise, and our high-plac'd Macbeth\n"
."Shall live the lease of nature, pay his breath\n"
."To time and mortal custom.--Yet my heart\n"
."Throbs to know one thing: tell me,--if your art\n"
."Can tell so much,--shall Banquo's issue ever\n"
."Reign in this kingdom?\n"
."\n"
."ALL.\n"
."Seek to know no more.\n"
."\n"
."MACBETH.\n"
."I will be satisfied: deny me this,\n"
."And an eternal curse fall on you! Let me know:--\n"
."Why sinks that cauldron? and what noise is this?\n"
."\n"
."[Hautboys.]\n"
."\n"
."FIRST WITCH.\n"
."Show!\n"
."\n"
."SECOND WITCH.\n"
."Show!\n"
."\n"
."THIRD WITCH.\n"
."Show!\n"
."\n"
."ALL.\n"
."Show his eyes, and grieve his heart;\n"
."Come like shadows, so depart!\n"
."\n"
."[Eight kings appear, and pass over in order, the last with a\n"
."glass in his hand; Banquo following.]\n"
."\n"
."MACBETH.\n"
."Thou are too like the spirit of Banquo; down!\n"
."Thy crown does sear mine eyeballs:--and thy hair,\n"
."Thou other gold-bound brow, is like the first;--\n"
."A third is like the former.--Filthy hags!\n"
."Why do you show me this?--A fourth!--Start, eyes!\n"
."What, will the line stretch out to the crack of doom?\n"
."Another yet!--A seventh!--I'll see no more:--\n"
."And yet the eighth appears, who bears a glass\n"
."Which shows me many more; and some I see\n"
."That twofold balls and treble sceptres carry:\n"
."Horrible sight!--Now I see 'tis true;\n"
."For the blood-bolter'd Banquo smiles upon me,\n"
."And points at them for his.--What! is this so?\n"
."\n"
."FIRST WITCH.\n"
."Ay, sir, all this is so:--but why\n"
."Stands Macbeth thus amazedly?--\n"
."Come,sisters, cheer we up his sprites,\n"
."And show the best of our delights;\n"
."I'll charm the air to give a sound,\n"
."While you perform your antic round;\n"
."That this great king may kindly say,\n"
."Our duties did his welcome pay.\n"
."\n"
."[Music. The Witches dance, and then vanish.]\n"
."\n"
."MACBETH.\n"
."Where are they? Gone?--Let this pernicious hour\n"
."Stand aye accursed in the calendar!--\n"
."Come in, without there!\n"
."\n"
."[Enter Lennox.]\n"
."\n"
."LENNOX.\n"
."What's your grace's will?\n"
."\n"
."MACBETH.\n"
."Saw you the weird sisters?\n"
."\n"
."LENNOX.\n"
."No, my lord.\n"
."\n"
."MACBETH.\n"
."Came they not by you?\n"
."\n"
."LENNOX.\n"
."No indeed, my lord.\n"
."\n"
."MACBETH.\n"
."Infected be the air whereon they ride;\n"
."And damn'd all those that trust them!--I did hear\n"
."The galloping of horse: who was't came by?\n"
."\n"
."LENNOX.\n"
."'Tis two or three, my lord, that bring you word\n"
."Macduff is fled to England.\n"
."\n"
."MACBETH.\n"
."Fled to England!\n"
."\n"
."LENNOX.\n"
."Ay, my good lord.\n"
."\n"
."MACBETH.\n"
."Time, thou anticipat'st my dread exploits:\n"
."The flighty purpose never is o'ertook\n"
."Unless the deed go with it: from this moment\n"
."The very firstlings of my heart shall be\n"
."The firstlings of my hand. And even now,\n"
."To crown my thoughts with acts, be it thought and done:\n"
."The castle of Macduff I will surprise;\n"
."Seize upon Fife; give to the edge o' the sword\n"
."His wife, his babes, and all unfortunate souls\n"
."That trace him in his line. No boasting like a fool;\n"
."This deed I'll do before this purpose cool:\n"
."But no more sights!--Where are these gentlemen?\n"
."Come, bring me where they are.\n"
."\n"
."[Exeunt.]\n"
."\n"
."\n"
."\n"
."SCENE II. Fife. A Room in Macduff's Castle.\n"
."\n"
."[Enter Lady Macduff, her Son, and Ross.]\n"
."\n"
."LADY MACDUFF.\n"
."What had he done, to make him fly the land?\n"
."\n"
."ROSS.\n"
."You must have patience, madam.\n"
."\n"
."LADY MACDUFF.\n"
."He had none:\n"
."His flight was madness: when our actions do not,\n"
."Our fears do make us traitors.\n"
."\n"
."ROSS.\n"
."You know not\n"
."Whether it was his wisdom or his fear.\n"
."\n"
."LADY MACDUFF.\n"
."Wisdom! to leave his wife, to leave his babes,\n"
."His mansion, and his titles, in a place\n"
."From whence himself does fly? He loves us not:\n"
."He wants the natural touch; for the poor wren,\n"
."The most diminutive of birds, will fight,\n"
."Her young ones in her nest, against the owl.\n"
."All is the fear, and nothing is the love;\n"
."As little is the wisdom, where the flight\n"
."So runs against all reason.\n"
."\n"
."ROSS.\n"
."My dearest coz,\n"
."I pray you, school yourself: but, for your husband,\n"
."He is noble, wise, Judicious, and best knows\n"
."The fits o' the season. I dare not speak much further:\n"
."But cruel are the times, when we are traitors,\n"
."And do not know ourselves; when we hold rumour\n"
."From what we fear, yet know not what we fear,\n"
."But float upon a wild and violent sea\n"
."Each way and move.--I take my leave of you:\n"
."Shall not be long but I'll be here again:\n"
."Things at the worst will cease, or else climb upward\n"
."To what they were before.--My pretty cousin,\n"
."Blessing upon you!\n"
."\n"
."LADY MACDUFF.\n"
."Father'd he is, and yet he's fatherless.\n"
."\n"
."ROSS.\n"
."I am so much a fool, should I stay longer,\n"
."It would be my disgrace and your discomfort:\n"
."I take my leave at once.\n"
."\n"
."[Exit.]\n"
."\n"
."LADY MACDUFF.\n"
."Sirrah, your father's dead;\n"
."And what will you do now? How will you live?\n"
."\n"
."SON.\n"
."As birds do, mother.\n"
."\n"
."LADY MACDUFF.\n"
."What, with worms and flies?\n"
."\n"
."SON.\n"
."With what I get, I mean; and so do they.\n"
."\n"
."LADY MACDUFF.\n"
."Poor bird! thou'dst never fear the net nor lime,\n"
."The pit-fall nor the gin.\n"
."\n"
."SON.\n"
."Why should I, mother? Poor birds they are not set for.\n"
."My father is not dead, for all your saying.\n"
."\n"
."LADY MACDUFF.\n"
."Yes, he is dead: how wilt thou do for father?\n"
."\n"
."SON.\n"
."Nay, how will you do for a husband?\n"
."\n"
."LADY MACDUFF.\n"
."Why, I can buy me twenty at any market.\n"
."\n"
."SON.\n"
."Then you'll buy 'em to sell again.\n"
."\n"
."LADY MACDUFF.\n"
."Thou speak'st with all thy wit; and yet, i' faith,\n"
."With wit enough for thee.\n"
."\n"
."SON.\n"
."Was my father a traitor, mother?\n"
."\n"
."LADY MACDUFF.\n"
."Ay, that he was.\n"
."\n"
."SON.\n"
."What is a traitor?\n"
."\n"
."LADY MACDUFF.\n"
."Why, one that swears and lies.\n"
."\n"
."SON.\n"
."And be all traitors that do so?\n"
."\n"
."LADY MACDUFF.\n"
."Everyone that does so is a traitor, and must be hanged.\n"
."\n"
."SON.\n"
."And must they all be hanged that swear and lie?\n"
."\n"
."LADY MACDUFF.\n"
."Every one.\n"
."\n"
."SON.\n"
."Who must hang them?\n"
."\n"
."LADY MACDUFF.\n"
."Why, the honest men.\n"
."\n"
."SON.\n"
."Then the liars and swearers are fools: for there are liars\n"
."and swearers enow to beat the honest men and hang up them.\n"
."\n"
."LADY MACDUFF.\n"
."Now, God help thee, poor monkey! But how wilt\n"
."thou do for a father?\n"
."\n"
."SON.\n"
."If he were dead, you'ld weep for him: if you would not, it\n"
."were a good sign that I should quickly have a new father.\n"
."\n"
."LADY MACDUFF.\n"
."Poor prattler, how thou talk'st!\n"
."\n"
."[Enter a Messenger.]\n"
."\n"
."MESSENGER.\n"
."Bless you, fair dame! I am not to you known,\n"
."Though in your state of honor I am perfect.\n"
."I doubt some danger does approach you nearly:\n"
."If you will take a homely man's advice,\n"
."Be not found here; hence, with your little ones.\n"
."To fright you thus, methinks, I am too savage;\n"
."To do worse to you were fell cruelty,\n"
."Which is too nigh your person. Heaven preserve you!\n"
."I dare abide no longer.\n"
."\n"
."[Exit.]\n"
."\n"
."LADY MACDUFF.\n"
."Whither should I fly?\n"
."I have done no harm. But I remember now\n"
."I am in this earthly world; where to do harm\n"
."Is often laudable; to do good sometime\n"
."Accounted dangerous folly:  why then, alas,\n"
."Do I put up that womanly defence,\n"
."To say I have done no harm?--What are these faces?\n"
."\n"
."[Enter Murderers.]\n"
."\n"
."FIRST MURDERER.\n"
."Where is your husband?\n"
."\n"
."LADY MACDUFF.\n"
."I hope, in no place so unsanctified\n"
."Where such as thou mayst find him.\n"
."\n"
."FIRST MURDERER.\n"
."He's a traitor.\n"
."\n"
."SON.\n"
."Thou liest, thou shag-haar'd villain!\n"
."\n"
."FIRST MURDERER.\n"
."What, you egg!\n"
."\n"
."[Stabbing him.]\n"
."\n"
."Young fry of treachery!\n"
."\n"
."SON.\n"
."He has kill'd me, mother:\n"
."Run away, I pray you!\n"
."\n"
."[Dies. Exit Lady Macduff, crying Murder, and pursued by the\n"
."Murderers.]\n"
."\n"
."\n"
."\n"
."SCENE III. England. Before the King's Palace.\n"
."\n"
."[Enter Malcolm and Macduff.]\n"
."\n"
."MALCOLM.\n"
."Let us seek out some desolate shade and there\n"
."Weep our sad bosoms empty.\n"
."\n"
."MACDUFF.\n"
."Let us rather\n"
."Hold fast the mortal sword, and, like good men,\n"
."Bestride our down-fall'n birthdom: each new morn\n"
."New widows howl; new orphans cry; new sorrows\n"
."Strike heaven on the face, that it resounds\n"
."As if it felt with Scotland, and yell'd out\n"
."Like syllable of dolour.\n"
."\n"
."MALCOLM.\n"
."What I believe, I'll wail;\n"
."What know, believe; and what I can redress,\n"
."As I shall find the time to friend, I will.\n"
."What you have spoke, it may be so perchance.\n"
."This tyrant, whose sole name blisters our tongues,\n"
."Was once thought honest: you have loved him well;\n"
."He hath not touch'd you yet. I am young; but something\n"
."You may deserve of him through me; and wisdom\n"
."To offer up a weak, poor, innocent lamb\n"
."To appease an angry god.\n"
."\n"
."MACDUFF.\n"
."I am not treacherous.\n"
."\n"
."MALCOLM.\n"
."But Macbeth is.\n"
."A good and virtuous nature may recoil\n"
."In an imperial charge. But I shall crave your pardon;\n"
."That which you are, my thoughts cannot transpose;\n"
."Angels are bright still, though the brightest fell:\n"
."Though all things foul would wear the brows of grace,\n"
."Yet grace must still look so.\n"
."\n"
."MACDUFF.\n"
."I have lost my hopes.\n"
."\n"
."MALCOLM.\n"
."Perchance even there where I did find my doubts.\n"
."Why in that rawness left you wife and child,--\n"
."Those precious motives, those strong knots of love,--\n"
."Without leave-taking?--I pray you,\n"
."Let not my jealousies be your dishonors,\n"
."But mine own safeties:--you may be rightly just,\n"
."Whatever I shall think.\n"
."\n"
."MACDUFF.\n"
."Bleed, bleed, poor country!\n"
."Great tyranny, lay thou thy basis sure,\n"
."For goodness dare not check thee! wear thou thy wrongs,\n"
."The title is affeer'd.--Fare thee well, lord:\n"
."I would not be the villain that thou think'st\n"
."For the whole space that's in the tyrant's grasp\n"
."And the rich East to boot.\n"
."\n"
."MALCOLM.\n"
."Be not offended:\n"
."I speak not as in absolute fear of you.\n"
."I think our country sinks beneath the yoke;\n"
."It weeps, it bleeds; and each new day a gash\n"
."Is added to her wounds. I think, withal,\n"
."There would be hands uplifted in my right;\n"
."And here, from gracious England, have I offer\n"
."Of goodly thousands: but, for all this,\n"
."When I shall tread upon the tyrant's head,\n"
."Or wear it on my sword, yet my poor country\n"
."Shall have more vices than it had before;\n"
."More suffer, and more sundry ways than ever,\n"
."By him that shall succeed.\n"
."\n"
."MACDUFF.\n"
."What should he be?\n"
."\n"
."MALCOLM.\n"
."It is myself I mean: in whom I know\n"
."All the particulars of vice so grafted\n"
."That, when they shall be open'd, black Macbeth\n"
."Will seem as pure as snow; and the poor state\n"
."Esteem him as a lamb, being compar'd\n"
."With my confineless harms.\n"
."\n"
."MACDUFF.\n"
."Not in the legions\n"
."Of horrid hell can come a devil more damn'd\n"
."In evils to top Macbeth.\n"
."\n"
."MALCOLM.\n"
."I grant him bloody,\n"
."Luxurious, avaricious, false, deceitful,\n"
."Sudden, malicious, smacking of every sin\n"
."That has a name: but there's no bottom, none,\n"
."In my voluptuousness: your wives, your daughters,\n"
."Your matrons, and your maids, could not fill up\n"
."The cistern of my lust; and my desire\n"
."All continent impediments would o'erbear,\n"
."That did oppose my will: better Macbeth\n"
."Than such an one to reign.\n"
."\n"
."MACDUFF.\n"
."Boundless intemperance\n"
."In nature is a tyranny; it hath been\n"
."The untimely emptying of the happy throne,\n"
."And fall of many kings. But fear not yet\n"
."To take upon you what is yours: you may\n"
."Convey your pleasures in a spacious plenty,\n"
."And yet seem cold, the time you may so hoodwink.\n"
."We have willing dames enough; there cannot be\n"
."That vulture in you, to devour so many\n"
."As will to greatness dedicate themselves,\n"
."Finding it so inclin'd.\n"
."\n"
."MALCOLM.\n"
."With this there grows,\n"
."In my most ill-compos'd affection, such\n"
."A stanchless avarice, that, were I king,\n"
."I should cut off the nobles for their lands;\n"
."Desire his jewels, and this other's house:\n"
."And my more-having would be as a sauce\n"
."To make me hunger more; that I should forge\n"
."Quarrels unjust against the good and loyal,\n"
."Destroying them for wealth.\n"
."\n"
."MACDUFF.\n"
."This avarice\n"
."Sticks deeper; grows with more pernicious root\n"
."Than summer-seeming lust; and it hath been\n"
."The sword of our slain kings: yet do not fear;\n"
."Scotland hath foysons to fill up your will,\n"
."Of your mere own: all these are portable,\n"
."With other graces weigh'd.\n"
."\n"
."MALCOLM.\n"
."But I have none: the king-becoming graces,\n"
."As justice, verity, temperance, stableness,\n"
."Bounty, perseverance, mercy, lowliness,\n"
."Devotion, patience, courage, fortitude,\n"
."I have no relish of them; but abound\n"
."In the division of each several crime,\n"
."Acting it many ways. Nay, had I power, I should\n"
."Pour the sweet milk of concord into hell,\n"
."Uproar the universal peace, confound\n"
."All unity on earth.\n"
."\n"
."MACDUFF.\n"
."O Scotland, Scotland!\n"
."\n"
."MALCOLM.\n"
."If such a one be fit to govern, speak:\n"
."I am as I have spoken.\n"
."\n"
."MACDUFF.\n"
."Fit to govern!\n"
."No, not to live!--O nation miserable,\n"
."With an untitled tyrant bloody-scepter'd,\n"
."When shalt thou see thy wholesome days again,\n"
."Since that the truest issue of thy throne\n"
."By his own interdiction stands accurs'd\n"
."And does blaspheme his breed?--Thy royal father\n"
."Was a most sainted king; the queen that bore thee,\n"
."Oftener upon her knees than on her feet,\n"
."Died every day she lived. Fare-thee-well!\n"
."These evils thou repeat'st upon thyself\n"
."Have banish'd me from Scotland.--O my breast,\n"
."Thy hope ends here!\n"
."\n"
."MALCOLM.\n"
."Macduff, this noble passion,\n"
."Child of integrity, hath from my soul\n"
."Wiped the black scruples, reconcil'd my thoughts\n"
."To thy good truth and honour. Devilish Macbeth\n"
."By many of these trains hath sought to win me\n"
."Into his power; and modest wisdom plucks me\n"
."From over-credulous haste: but God above\n"
."Deal between thee and me! for even now\n"
."I put myself to thy direction, and\n"
."Unspeak mine own detraction; here abjure\n"
."The taints and blames I laid upon myself,\n"
."For strangers to my nature. I am yet\n"
."Unknown to woman; never was forsworn;\n"
."Scarcely have coveted what was mine own;\n"
."At no time broke my faith; would not betray\n"
."The devil to his fellow; and delight\n"
."No less in truth than life: my first false speaking\n"
."Was this upon myself:--what I am truly,\n"
."Is thine and my poor country's to command:\n"
."Whither, indeed, before thy here-approach,\n"
."Old Siward, with ten thousand warlike men\n"
."Already at a point, was setting forth:\n"
."Now we'll together; and the chance of goodness\n"
."Be like our warranted quarrel! Why are you silent?\n"
."\n"
."MACDUFF.\n"
."Such welcome and unwelcome things at once\n"
."'Tis hard to reconcile.\n"
."\n"
."[Enter a Doctor.]\n"
."\n"
."MALCOLM.\n"
."Well; more anon.--Comes the king forth, I pray you?\n"
."\n"
."DOCTOR.\n"
."Ay, sir: there are a crew of wretched souls\n"
."That stay his cure: their malady convinces\n"
."The great assay of art; but, at his touch,\n"
."Such sanctity hath heaven given his hand,\n"
."They presently amend.\n"
."\n"
."MALCOLM.\n"
."I thank you, doctor.\n"
."\n"
."[Exit Doctor.]\n"
."\n"
."MACDUFF.\n"
."What's the disease he means?\n"
."\n"
."MALCOLM.\n"
."'Tis call'd the evil:\n"
."A most miraculous work in this good king;\n"
."Which often, since my here-remain in England,\n"
."I have seen him do. How he solicits heaven,\n"
."Himself best knows: but strangely-visited people,\n"
."All swoln and ulcerous, pitiful to the eye,\n"
."The mere despair of surgery, he cures;\n"
."Hanging a golden stamp about their necks,\n"
."Put on with holy prayers: and 'tis spoken,\n"
."To the succeeding royalty he leaves\n"
."The healing benediction. With this strange virtue,\n"
."He hath a heavenly gift of prophecy;\n"
."And sundry blessings hang about his throne,\n"
."That speak him full of grace.\n"
."\n"
."MACDUFF.\n"
."See, who comes here?\n"
."\n"
."MALCOLM.\n"
."My countryman; but yet I know him not.\n"
."\n"
."[Enter Ross.]\n"
."\n"
."MACDUFF.\n"
."My ever-gentle cousin, welcome hither.\n"
."\n"
."MALCOLM.\n"
."I know him now. Good God, betimes remove\n"
."The means that makes us strangers!\n"
."\n"
."ROSS.\n"
."Sir, amen.\n"
."\n"
."MACDUFF.\n"
."Stands Scotland where it did?\n"
."\n"
."ROSS.\n"
."Alas, poor country,--\n"
."Almost afraid to know itself! It cannot\n"
."Be call'd our mother, but our grave: where nothing,\n"
."But who knows nothing, is once seen to smile;\n"
."Where sighs, and groans, and shrieks, that rent the air,\n"
."Are made, not mark'd; where violent sorrow seems\n"
."A modern ecstasy; the dead man's knell\n"
."Is there scarce ask'd for who; and good men's lives\n"
."Expire before the flowers in their caps,\n"
."Dying or ere they sicken.\n"
."\n"
."MACDUFF.\n"
."O, relation\n"
."Too nice, and yet too true!\n"
."\n"
."MALCOLM.\n"
."What's the newest grief?\n"
."\n"
."ROSS.\n"
."That of an hour's age doth hiss the speaker;\n"
."Each minute teems a new one.\n"
."\n"
."MACDUFF.\n"
."How does my wife?\n"
."\n"
."ROSS.\n"
."Why, well.\n"
."\n"
."MACDUFF.\n"
."And all my children?\n"
."\n"
."ROSS.\n"
."Well too.\n"
."\n"
."MACDUFF.\n"
."The tyrant has not batter'd at their peace?\n"
."\n"
."ROSS.\n"
."No; they were well at peace when I did leave 'em.\n"
."\n"
."MACDUFF.\n"
."Be not a niggard of your speech: how goes't?\n"
."\n"
."ROSS.\n"
."When I came hither to transport the tidings,\n"
."Which I have heavily borne, there ran a rumour\n"
."Of many worthy fellows that were out;\n"
."Which was to my belief witness'd the rather,\n"
."For that I saw the tyrant's power a-foot:\n"
."Now is the time of help; your eye in Scotland\n"
."Would create soldiers, make our women fight,\n"
."To doff their dire distresses.\n"
."\n"
."MALCOLM.\n"
."Be't their comfort\n"
."We are coming thither: gracious England hath\n"
."Lent us good Siward and ten thousand men;\n"
."An older and a better soldier none\n"
."That Christendom gives out.\n"
."\n"
."ROSS.\n"
."Would I could answer\n"
."This comfort with the like! But I have words\n"
."That would be howl'd out in the desert air,\n"
."Where hearing should not latch them.\n"
."\n"
."MACDUFF.\n"
."What concern they?\n"
."The general cause? or is it a fee-grief\n"
."Due to some single breast?\n"
."\n"
."ROSS.\n"
."No mind that's honest\n"
."But in it shares some woe; though the main part\n"
."Pertains to you alone.\n"
."\n"
."MACDUFF.\n"
."If it be mine,\n"
."Keep it not from me, quickly let me have it.\n"
."\n"
."ROSS.\n"
."Let not your ears despise my tongue for ever,\n"
."Which shall possess them with the heaviest sound\n"
."That ever yet they heard.\n"
."\n"
."MACDUFF.\n"
."Humh! I guess at it.\n"
."\n"
."ROSS.\n"
."Your castle is surpris'd; your wife and babes\n"
."Savagely slaughter'd: to relate the manner\n"
."Were, on the quarry of these murder'd deer,\n"
."To add the death of you.\n"
."\n"
."MALCOLM.\n"
."Merciful heaven!--\n"
."What, man! ne'er pull your hat upon your brows;\n"
."Give sorrow words: the grief that does not speak\n"
."Whispers the o'er-fraught heart, and bids it break.\n"
."\n"
."MACDUFF.\n"
."My children too?\n"
."\n"
."ROSS.\n"
."Wife, children, servants, all\n"
."That could be found.\n"
."\n"
."MACDUFF.\n"
."And I must be from thence!\n"
."My wife kill'd too?\n"
."\n"
."ROSS.\n"
."I have said.\n"
."\n"
."MALCOLM.\n"
."Be comforted:\n"
."Let's make us medicines of our great revenge,\n"
."To cure this deadly grief.\n"
."\n"
."MACDUFF.\n"
."He has no children.--All my pretty ones?\n"
."Did you say all?--O hell-kite!--All?\n"
."What, all my pretty chickens and their dam\n"
."At one fell swoop?\n"
."\n"
."MALCOLM.\n"
."Dispute it like a man.\n"
."\n"
."MACDUFF.\n"
."I shall do so;\n"
."But I must also feel it as a man:\n"
."I cannot but remember such things were,\n"
."That were most precious to me.--Did heaven look on,\n"
."And would not take their part? Sinful Macduff,\n"
."They were all struck for thee! naught that I am,\n"
."Not for their own demerits, but for mine,\n"
."Fell slaughter on their souls: heaven rest them now!\n"
."\n"
."MALCOLM.\n"
."Be this the whetstone of your sword. Let grief\n"
."Convert to anger; blunt not the heart, enrage it.\n"
."\n"
."MACDUFF.\n"
."O, I could play the woman with mine eye,\n"
."And braggart with my tongue!--But, gentle heavens,\n"
."Cut short all intermission; front to front\n"
."Bring thou this fiend of Scotland and myself;\n"
."Within my sword's length set him; if he 'scape,\n"
."Heaven forgive him too!\n"
."\n"
."MALCOLM.\n"
."This tune goes manly.\n"
."Come, go we to the king; our power is ready;\n"
."Our lack is nothing but our leave: Macbeth\n"
."Is ripe for shaking, and the powers above\n"
."Put on their instruments. Receive what cheer you may;\n"
."The night is long that never finds the day.\n"
."\n"
."[Exeunt.]\n"
."\n";
}

sub Willows { return "I. THE RIVER BANK\n"
."\n"
."The Mole had been working very hard all the morning, spring-cleaning his\n"
."little home. First with brooms, then with dusters; then on ladders and\n"
."steps and chairs, with a brush and a pail of whitewash; till he had dust\n"
."in his throat and eyes, and splashes of whitewash all over his black\n"
."fur, and an aching back and weary arms. Spring was moving in the air\n"
."above and in the earth below and around him, penetrating even his dark\n"
."and lowly little house with its spirit of divine discontent and longing.\n"
."It was small wonder, then, that he suddenly flung down his brush on the\n"
."floor, said 'Bother!' and 'O blow!' and also 'Hang spring-cleaning!'\n"
."and bolted out of the house without even waiting to put on his coat.\n"
."Something up above was calling him imperiously, and he made for\n"
."the steep little tunnel which answered in his case to the graveled\n"
."carriage-drive owned by animals whose residences are nearer to the sun\n"
."and air. So he scraped and scratched and scrabbled and scrooged and\n"
."then he scrooged again and scrabbled and scratched and scraped, working\n"
."busily with his little paws and muttering to himself, 'Up we go! Up we\n"
."go!' till at last, pop! his snout came out into the sunlight, and he\n"
."found himself rolling in the warm grass of a great meadow.\n"
."\n"
."'This is fine!' he said to himself. 'This is better than whitewashing!'\n"
."The sunshine struck hot on his fur, soft breezes caressed his heated\n"
."brow, and after the seclusion of the cellarage he had lived in so long\n"
."the carol of happy birds fell on his dulled hearing almost like a shout.\n"
."Jumping off all his four legs at once, in the joy of living and the\n"
."delight of spring without its cleaning, he pursued his way across the\n"
."meadow till he reached the hedge on the further side.\n"
."\n"
."'Hold up!' said an elderly rabbit at the gap. 'Sixpence for the\n"
."privilege of passing by the private road!' He was bowled over in an\n"
."instant by the impatient and contemptuous Mole, who trotted along the\n"
."side of the hedge chaffing the other rabbits as they peeped hurriedly\n"
."from their holes to see what the row was about. 'Onion-sauce!\n"
."Onion-sauce!' he remarked jeeringly, and was gone before they could\n"
."think of a thoroughly satisfactory reply. Then they all started\n"
."grumbling at each other. 'How STUPID you are! Why didn't you tell\n"
."him----' 'Well, why didn't YOU say----' 'You might have reminded\n"
."him----' and so on, in the usual way; but, of course, it was then much\n"
."too late, as is always the case.\n"
."\n"
."It all seemed too good to be true. Hither and thither through the\n"
."meadows he rambled busily, along the hedgerows, across the\n"
."copses, finding everywhere birds building, flowers budding, leaves\n"
."thrusting--everything happy, and progressive, and occupied. And instead\n"
."of having an uneasy conscience pricking him and whispering 'whitewash!'\n"
."he somehow could only feel how jolly it was to be the only idle dog\n"
."among all these busy citizens. After all, the best part of a holiday\n"
."is perhaps not so much to be resting yourself, as to see all the other\n"
."fellows busy working.\n"
."\n"
."He thought his happiness was complete when, as he meandered aimlessly\n"
."along, suddenly he stood by the edge of a full-fed river. Never in\n"
."his life had he seen a river before--this sleek, sinuous, full-bodied\n"
."animal, chasing and chuckling, gripping things with a gurgle and\n"
."leaving them with a laugh, to fling itself on fresh playmates that shook\n"
."themselves free, and were caught and held again. All was a-shake and\n"
."a-shiver--glints and gleams and sparkles, rustle and swirl, chatter and\n"
."bubble. The Mole was bewitched, entranced, fascinated. By the side of\n"
."the river he trotted as one trots, when very small, by the side of a man\n"
."who holds one spell-bound by exciting stories; and when tired at\n"
."last, he sat on the bank, while the river still chattered on to him,\n"
."a babbling procession of the best stories in the world, sent from the\n"
."heart of the earth to be told at last to the insatiable sea.\n"
."\n"
."As he sat on the grass and looked across the river, a dark hole in the\n"
."bank opposite, just above the water's edge, caught his eye, and dreamily\n"
."he fell to considering what a nice snug dwelling-place it would make for\n"
."an animal with few wants and fond of a bijou riverside residence, above\n"
."flood level and remote from noise and dust. As he gazed, something\n"
."bright and small seemed to twinkle down in the heart of it, vanished,\n"
."then twinkled once more like a tiny star. But it could hardly be a star\n"
."in such an unlikely situation; and it was too glittering and small for a\n"
."glow-worm. Then, as he looked, it winked at him, and so declared itself\n"
."to be an eye; and a small face began gradually to grow up round it, like\n"
."a frame round a picture.\n"
."\n"
."A brown little face, with whiskers.\n"
."\n"
."A grave round face, with the same twinkle in its eye that had first\n"
."attracted his notice.\n"
."\n"
."Small neat ears and thick silky hair.\n"
."\n"
."It was the Water Rat!\n"
."\n"
."Then the two animals stood and regarded each other cautiously.\n"
."\n"
."'Hullo, Mole!' said the Water Rat.\n"
."\n"
."'Hullo, Rat!' said the Mole.\n"
."\n"
."'Would you like to come over?' enquired the Rat presently.\n"
."\n"
."'Oh, its all very well to TALK,' said the Mole, rather pettishly, he\n"
."being new to a river and riverside life and its ways.\n"
."\n"
."The Rat said nothing, but stooped and unfastened a rope and hauled\n"
."on it; then lightly stepped into a little boat which the Mole had not\n"
."observed. It was painted blue outside and white within, and was just the\n"
."size for two animals; and the Mole's whole heart went out to it at once,\n"
."even though he did not yet fully understand its uses.\n"
."\n"
."The Rat sculled smartly across and made fast. Then he held up his\n"
."forepaw as the Mole stepped gingerly down. 'Lean on that!' he said.\n"
."'Now then, step lively!' and the Mole to his surprise and rapture found\n"
."himself actually seated in the stern of a real boat.\n"
."\n"
."'This has been a wonderful day!' said he, as the Rat shoved off and took\n"
."to the sculls again. 'Do you know, I've never been in a boat before in\n"
."all my life.'\n"
."\n"
."'What?' cried the Rat, open-mouthed: 'Never been in a--you never--well\n"
."I--what have you been doing, then?'\n"
."\n"
."'Is it so nice as all that?' asked the Mole shyly, though he was quite\n"
."prepared to believe it as he leant back in his seat and surveyed the\n"
."cushions, the oars, the rowlocks, and all the fascinating fittings, and\n"
."felt the boat sway lightly under him.\n"
."\n"
."'Nice? It's the ONLY thing,' said the Water Rat solemnly, as he\n"
."leant forward for his stroke. 'Believe me, my young friend, there is\n"
."NOTHING--absolute nothing--half so much worth doing as simply\n"
."messing about in boats. Simply messing,' he went on dreamily:\n"
."'messing--about--in--boats; messing----'\n"
."\n"
."'Look ahead, Rat!' cried the Mole suddenly.\n"
."\n"
."It was too late. The boat struck the bank full tilt. The dreamer, the\n"
."joyous oarsman, lay on his back at the bottom of the boat, his heels in\n"
."the air.\n"
."\n"
."'--about in boats--or WITH boats,' the Rat went on composedly, picking\n"
."himself up with a pleasant laugh. 'In or out of 'em, it doesn't matter.\n"
."Nothing seems really to matter, that's the charm of it. Whether you get\n"
."away, or whether you don't; whether you arrive at your destination or\n"
."whether you reach somewhere else, or whether you never get anywhere at\n"
."all, you're always busy, and you never do anything in particular; and\n"
."when you've done it there's always something else to do, and you can do\n"
."it if you like, but you'd much better not. Look here! If you've really\n"
."nothing else on hand this morning, supposing we drop down the river\n"
."together, and have a long day of it?'\n"
."\n"
."The Mole waggled his toes from sheer happiness, spread his chest with\n"
."a sigh of full contentment, and leaned back blissfully into the soft\n"
."cushions. 'WHAT a day I'm having!' he said. 'Let us start at once!'\n"
."\n"
."'Hold hard a minute, then!' said the Rat. He looped the painter through\n"
."a ring in his landing-stage, climbed up into his hole above, and after\n"
."a short interval reappeared staggering under a fat, wicker\n"
."luncheon-basket.\n"
."\n"
."'Shove that under your feet,' he observed to the Mole, as he passed\n"
."it down into the boat. Then he untied the painter and took the sculls\n"
."again.\n"
."\n"
."'What's inside it?' asked the Mole, wriggling with curiosity.\n"
."\n"
."'There's cold chicken inside it,' replied the Rat briefly;\n"
."'coldtonguecoldhamcoldbeefpickledgherkinssaladfrenchrollscresssan\n"
."dwichespottedmeatgingerbeerlemonadesodawater----'\n"
."\n"
."'O stop, stop,' cried the Mole in ecstacies: 'This is too much!'\n"
."\n"
."'Do you really think so?' enquired the Rat seriously. 'It's only what I\n"
."always take on these little excursions; and the other animals are always\n"
."telling me that I'm a mean beast and cut it VERY fine!'\n"
."\n"
."The Mole never heard a word he was saying. Absorbed in the new life he\n"
."was entering upon, intoxicated with the sparkle, the ripple, the scents\n"
."and the sounds and the sunlight, he trailed a paw in the water and\n"
."dreamed long waking dreams. The Water Rat, like the good little fellow\n"
."he was, sculled steadily on and forebore to disturb him.\n"
."\n"
."'I like your clothes awfully, old chap,' he remarked after some half\n"
."an hour or so had passed. 'I'm going to get a black velvet smoking-suit\n"
."myself some day, as soon as I can afford it.'\n"
."\n"
."'I beg your pardon,' said the Mole, pulling himself together with an\n"
."effort. 'You must think me very rude; but all this is so new to me.\n"
."So--this--is--a--River!'\n"
."\n"
."'THE River,' corrected the Rat.\n"
."\n"
."'And you really live by the river? What a jolly life!'\n"
."\n"
."'By it and with it and on it and in it,' said the Rat. 'It's brother\n"
."and sister to me, and aunts, and company, and food and drink, and\n"
."(naturally) washing. It's my world, and I don't want any other. What it\n"
."hasn't got is not worth having, and what it doesn't know is not worth\n"
."knowing. Lord! the times we've had together! Whether in winter or\n"
."summer, spring or autumn, it's always got its fun and its excitements.\n"
."When the floods are on in February, and my cellars and basement are\n"
."brimming with drink that's no good to me, and the brown water runs by my\n"
."best bedroom window; or again when it all drops away and, shows patches\n"
."of mud that smells like plum-cake, and the rushes and weed clog the\n"
."channels, and I can potter about dry shod over most of the bed of it and\n"
."find fresh food to eat, and things careless people have dropped out of\n"
."boats!'\n"
."\n"
."'But isn't it a bit dull at times?' the Mole ventured to ask. 'Just you\n"
."and the river, and no one else to pass a word with?'\n"
."\n"
."'No one else to--well, I mustn't be hard on you,' said the Rat with\n"
."forbearance. 'You're new to it, and of course you don't know. The bank\n"
."is so crowded nowadays that many people are moving away altogether: O\n"
."no, it isn't what it used to be, at all. Otters, kingfishers, dabchicks,\n"
."moorhens, all of them about all day long and always wanting you to DO\n"
."something--as if a fellow had no business of his own to attend to!'\n"
."\n"
."'What lies over THERE' asked the Mole, waving a paw towards a background\n"
."of woodland that darkly framed the water-meadows on one side of the\n"
."river.\n"
."\n"
."'That? O, that's just the Wild Wood,' said the Rat shortly. 'We don't go\n"
."there very much, we river-bankers.'\n"
."\n"
."'Aren't they--aren't they very NICE people in there?' said the Mole, a\n"
."trifle nervously.\n"
."\n"
."'W-e-ll,' replied the Rat, 'let me see. The squirrels are all right. AND\n"
."the rabbits--some of 'em, but rabbits are a mixed lot. And then there's\n"
."Badger, of course. He lives right in the heart of it; wouldn't live\n"
."anywhere else, either, if you paid him to do it. Dear old Badger! Nobody\n"
."interferes with HIM. They'd better not,' he added significantly.\n"
."\n"
."'Why, who SHOULD interfere with him?' asked the Mole.\n"
."\n"
."'Well, of course--there--are others,' explained the Rat in a hesitating\n"
."sort of way.\n"
."\n"
."'Weasels--and stoats--and foxes--and so on. They're all right in a\n"
."way--I'm very good friends with them--pass the time of day when we meet,\n"
."and all that--but they break out sometimes, there's no denying it, and\n"
."then--well, you can't really trust them, and that's the fact.'\n"
."\n"
."The Mole knew well that it is quite against animal-etiquette to dwell\n"
."on possible trouble ahead, or even to allude to it; so he dropped the\n"
."subject.\n"
."\n"
."'And beyond the Wild Wood again?' he asked: 'Where it's all blue\n"
."and dim, and one sees what may be hills or perhaps they mayn't, and\n"
."something like the smoke of towns, or is it only cloud-drift?'\n"
."\n"
."'Beyond the Wild Wood comes the Wide World,' said the Rat. 'And that's\n"
."something that doesn't matter, either to you or me. I've never been\n"
."there, and I'm never going, nor you either, if you've got any sense\n"
."at all. Don't ever refer to it again, please. Now then! Here's our\n"
."backwater at last, where we're going to lunch.'\n"
."\n"
."Leaving the main stream, they now passed into what seemed at first sight\n"
."like a little land-locked lake. Green turf sloped down to either edge,\n"
."brown snaky tree-roots gleamed below the surface of the quiet water,\n"
."while ahead of them the silvery shoulder and foamy tumble of a weir,\n"
."arm-in-arm with a restless dripping mill-wheel, that held up in its\n"
."turn a grey-gabled mill-house, filled the air with a soothing murmur\n"
."of sound, dull and smothery, yet with little clear voices speaking up\n"
."cheerfully out of it at intervals. It was so very beautiful that the\n"
."Mole could only hold up both forepaws and gasp, 'O my! O my! O my!'\n"
."\n"
."The Rat brought the boat alongside the bank, made her fast, helped the\n"
."still awkward Mole safely ashore, and swung out the luncheon-basket. The\n"
."Mole begged as a favour to be allowed to unpack it all by himself; and\n"
."the Rat was very pleased to indulge him, and to sprawl at full length on\n"
."the grass and rest, while his excited friend shook out the table-cloth\n"
."and spread it, took out all the mysterious packets one by one and\n"
."arranged their contents in due order, still gasping, 'O my! O my!' at\n"
."each fresh revelation. When all was ready, the Rat said, 'Now, pitch\n"
."in, old fellow!' and the Mole was indeed very glad to obey, for he had\n"
."started his spring-cleaning at a very early hour that morning, as people\n"
."WILL do, and had not paused for bite or sup; and he had been through a\n"
."very great deal since that distant time which now seemed so many days\n"
."ago.\n"
."\n"
."'What are you looking at?' said the Rat presently, when the edge of\n"
."their hunger was somewhat dulled, and the Mole's eyes were able to\n"
."wander off the table-cloth a little.\n"
."\n"
."'I am looking,' said the Mole, 'at a streak of bubbles that I see\n"
."travelling along the surface of the water. That is a thing that strikes\n"
."me as funny.'\n"
."\n"
."'Bubbles? Oho!' said the Rat, and chirruped cheerily in an inviting sort\n"
."of way.\n"
."\n"
."A broad glistening muzzle showed itself above the edge of the bank, and\n"
."the Otter hauled himself out and shook the water from his coat.\n"
."\n"
."'Greedy beggars!' he observed, making for the provender. 'Why didn't you\n"
."invite me, Ratty?'\n"
."\n"
."'This was an impromptu affair,' explained the Rat. 'By the way--my\n"
."friend Mr. Mole.'\n"
."\n"
."'Proud, I'm sure,' said the Otter, and the two animals were friends\n"
."forthwith.\n"
."\n"
."'Such a rumpus everywhere!' continued the Otter. 'All the world seems\n"
."out on the river to-day. I came up this backwater to try and get a\n"
."moment's peace, and then stumble upon you fellows!--At least--I beg\n"
."pardon--I don't exactly mean that, you know.'\n"
."\n"
."There was a rustle behind them, proceeding from a hedge wherein last\n"
."year's leaves still clung thick, and a stripy head, with high shoulders\n"
."behind it, peered forth on them.\n"
."\n"
."'Come on, old Badger!' shouted the Rat.\n"
."\n"
."The Badger trotted forward a pace or two; then grunted, 'H'm! Company,'\n"
."and turned his back and disappeared from view.\n"
."\n"
."'That's JUST the sort of fellow he is!' observed the disappointed Rat.\n"
."'Simply hates Society! Now we shan't see any more of him to-day. Well,\n"
."tell us, WHO'S out on the river?'\n"
."\n"
."'Toad's out, for one,' replied the Otter. 'In his brand-new wager-boat;\n"
."new togs, new everything!'\n"
."\n"
."The two animals looked at each other and laughed.\n"
."\n"
."'Once, it was nothing but sailing,' said the Rat, 'Then he tired of that\n"
."and took to punting. Nothing would please him but to punt all day\n"
."and every day, and a nice mess he made of it. Last year it was\n"
."house-boating, and we all had to go and stay with him in his house-boat,\n"
."and pretend we liked it. He was going to spend the rest of his life in\n"
."a house-boat. It's all the same, whatever he takes up; he gets tired of\n"
."it, and starts on something fresh.'\n"
."\n"
."'Such a good fellow, too,' remarked the Otter reflectively: 'But no\n"
."stability--especially in a boat!'\n"
."\n"
."From where they sat they could get a glimpse of the main stream across\n"
."the island that separated them; and just then a wager-boat flashed into\n"
."view, the rower--a short, stout figure--splashing badly and rolling a\n"
."good deal, but working his hardest. The Rat stood up and hailed him, but\n"
."Toad--for it was he--shook his head and settled sternly to his work.\n"
."\n"
."'He'll be out of the boat in a minute if he rolls like that,' said the\n"
."Rat, sitting down again.\n"
."\n"
."'Of course he will,' chuckled the Otter. 'Did I ever tell you that good\n"
."story about Toad and the lock-keeper? It happened this way. Toad....'\n"
."\n"
."An errant May-fly swerved unsteadily athwart the current in the\n"
."intoxicated fashion affected by young bloods of May-flies seeing life. A\n"
."swirl of water and a 'cloop!' and the May-fly was visible no more.\n"
."\n"
."Neither was the Otter.\n"
."\n"
."The Mole looked down. The voice was still in his ears, but the turf\n"
."whereon he had sprawled was clearly vacant. Not an Otter to be seen, as\n"
."far as the distant horizon.\n"
."\n"
."But again there was a streak of bubbles on the surface of the river.\n"
."\n"
."The Rat hummed a tune, and the Mole recollected that animal-etiquette\n"
."forbade any sort of comment on the sudden disappearance of one's friends\n"
."at any moment, for any reason or no reason whatever.\n"
."\n"
."'Well, well,' said the Rat, 'I suppose we ought to be moving. I wonder\n"
."which of us had better pack the luncheon-basket?' He did not speak as if\n"
."he was frightfully eager for the treat.\n"
."\n"
."'O, please let me,' said the Mole. So, of course, the Rat let him.\n"
."\n"
."Packing the basket was not quite such pleasant work as unpacking' the\n"
."basket. It never is. But the Mole was bent on enjoying everything, and\n"
."although just when he had got the basket packed and strapped up tightly\n"
."he saw a plate staring up at him from the grass, and when the job had\n"
."been done again the Rat pointed out a fork which anybody ought to\n"
."have seen, and last of all, behold! the mustard pot, which he had been\n"
."sitting on without knowing it--still, somehow, the thing got finished at\n"
."last, without much loss of temper.\n"
."\n"
."The afternoon sun was getting low as the Rat sculled gently homewards in\n"
."a dreamy mood, murmuring poetry-things over to himself, and not paying\n"
."much attention to Mole. But the Mole was very full of lunch, and\n"
."self-satisfaction, and pride, and already quite at home in a boat (so he\n"
."thought) and was getting a bit restless besides: and presently he said,\n"
."'Ratty! Please, _I_ want to row, now!'\n"
."\n"
."The Rat shook his head with a smile. 'Not yet, my young friend,' he\n"
."said--'wait till you've had a few lessons. It's not so easy as it\n"
."looks.'\n"
."\n"
."The Mole was quiet for a minute or two. But he began to feel more and\n"
."more jealous of Rat, sculling so strongly and so easily along, and his\n"
."pride began to whisper that he could do it every bit as well. He jumped\n"
."up and seized the sculls, so suddenly, that the Rat, who was gazing out\n"
."over the water and saying more poetry-things to himself, was taken by\n"
."surprise and fell backwards off his seat with his legs in the air for\n"
."the second time, while the triumphant Mole took his place and grabbed\n"
."the sculls with entire confidence.\n"
."\n"
."'Stop it, you SILLY ass!' cried the Rat, from the bottom of the boat.\n"
."'You can't do it! You'll have us over!'\n"
."\n"
."The Mole flung his sculls back with a flourish, and made a great dig at\n"
."the water. He missed the surface altogether, his legs flew up above\n"
."his head, and he found himself lying on the top of the prostrate Rat.\n"
."Greatly alarmed, he made a grab at the side of the boat, and the next\n"
."moment--Sploosh!\n"
."\n"
."Over went the boat, and he found himself struggling in the river.\n"
."\n"
."O my, how cold the water was, and O, how VERY wet it felt. How it sang\n"
."in his ears as he went down, down, down! How bright and welcome the sun\n"
."looked as he rose to the surface coughing and spluttering! How black was\n"
."his despair when he felt himself sinking again! Then a firm paw gripped\n"
."him by the back of his neck. It was the Rat, and he was evidently\n"
."laughing--the Mole could FEEL him laughing, right down his arm and\n"
."through his paw, and so into his--the Mole's--neck.\n"
."\n"
."The Rat got hold of a scull and shoved it under the Mole's arm; then he\n"
."did the same by the other side of him and, swimming behind, propelled\n"
."the helpless animal to shore, hauled him out, and set him down on the\n"
."bank, a squashy, pulpy lump of misery.\n"
."\n"
."When the Rat had rubbed him down a bit, and wrung some of the wet out of\n"
."him, he said, 'Now, then, old fellow! Trot up and down the towing-path\n"
."as hard as you can, till you're warm and dry again, while I dive for the\n"
."luncheon-basket.'\n"
."\n"
."So the dismal Mole, wet without and ashamed within, trotted about till\n"
."he was fairly dry, while the Rat plunged into the water again, recovered\n"
."the boat, righted her and made her fast, fetched his floating\n"
."property to shore by degrees, and finally dived successfully for the\n"
."luncheon-basket and struggled to land with it.\n"
."\n"
."When all was ready for a start once more, the Mole, limp and dejected,\n"
."took his seat in the stern of the boat; and as they set off, he said in\n"
."a low voice, broken with emotion, 'Ratty, my generous friend! I am very\n"
."sorry indeed for my foolish and ungrateful conduct. My heart quite fails\n"
."me when I think how I might have lost that beautiful luncheon-basket.\n"
."Indeed, I have been a complete ass, and I know it. Will you overlook it\n"
."this once and forgive me, and let things go on as before?'\n"
."\n"
."'That's all right, bless you!' responded the Rat cheerily. 'What's a\n"
."little wet to a Water Rat? I'm more in the water than out of it most\n"
."days. Don't you think any more about it; and, look here! I really think\n"
."you had better come and stop with me for a little time. It's very plain\n"
."and rough, you know--not like Toad's house at all--but you haven't seen\n"
."that yet; still, I can make you comfortable. And I'll teach you to row,\n"
."and to swim, and you'll soon be as handy on the water as any of us.'\n"
."\n"
."The Mole was so touched by his kind manner of speaking that he could\n"
."find no voice to answer him; and he had to brush away a tear or two with\n"
."the back of his paw. But the Rat kindly looked in another direction, and\n"
."presently the Mole's spirits revived again, and he was even able to give\n"
."some straight back-talk to a couple of moorhens who were sniggering to\n"
."each other about his bedraggled appearance.\n"
."\n"
."When they got home, the Rat made a bright fire in the parlour, and\n"
."planted the Mole in an arm-chair in front of it, having fetched down\n"
."a dressing-gown and slippers for him, and told him river stories till\n"
."supper-time. Very thrilling stories they were, too, to an earth-dwelling\n"
."animal like Mole. Stories about weirs, and sudden floods, and leaping\n"
."pike, and steamers that flung hard bottles--at least bottles were\n"
."certainly flung, and FROM steamers, so presumably BY them; and about\n"
."herons, and how particular they were whom they spoke to; and about\n"
."adventures down drains, and night-fishings with Otter, or excursions far\n"
."a-field with Badger. Supper was a most cheerful meal; but very shortly\n"
."afterwards a terribly sleepy Mole had to be escorted upstairs by his\n"
."considerate host, to the best bedroom, where he soon laid his head on\n"
."his pillow in great peace and contentment, knowing that his new-found\n"
."friend the River was lapping the sill of his window.\n"
."\n"
."This day was only the first of many similar ones for the emancipated\n"
."Mole, each of them longer and full of interest as the ripening summer\n"
."moved onward. He learnt to swim and to row, and entered into the joy\n"
."of running water; and with his ear to the reed-stems he caught, at\n"
."intervals, something of what the wind went whispering so constantly\n"
."among them.\n";
}

sub Alice_frag { return 
    "So she was considering in her own mind (as well as she could, for the\n"
  . "hot day made her feel very sleepy and stupid), whether the pleasure\n"
  . "of making a daisy-chain would be worth the trouble of getting up and\n"
  . "picking the daisies, when suddenly a White Rabbit with pink eyes ran\n"
  . "close by her.\n";
}

sub Hound_frag { return
    "\"Well, Watson, what do you make of it?\"\n"
  . "Holmes was sitting with his back to me, and I had given him no\n"
  . "sign of my occupation.\n"
  . "\"How did you know what I was doing?  I believe you have eyes in\n"
  . "the back of your head.\"\n";
}

sub Macbeth_frag { return
    "    Double, double, toil and trouble;\n"
  . "    Fire, burn; and cauldron, bubble.\n"
  . "    \n"
  . "    SECOND WITCH.\n"
  . "    Fillet of a fenny snake,\n"
  . "    In the caldron boil and bake;\n"
  . "    Eye of newt, and toe of frog,\n"
  . "    Wool of bat, and tongue of dog,\n"
  . "    Adder's fork, and blind-worm's sting,\n"
  . "    Lizard's leg, and howlet's wing,--\n"
  . "    For a charm of powerful trouble,\n"
  . "    Like a hell-broth boil and bubble.\n";
}

sub Willows_frag { return
    "'This is fine!' he said to himself. 'This is better than whitewashing!'\n"
  . "The sunshine struck hot on his fur, soft breezes caressed his heated\n"
  . "brow, and after the seclusion of the cellarage he had lived in so long\n"
  . "the carol of happy birds fell on his dulled hearing almost like a shout.";
}

1;

