/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSBagIndex;
import org.apache.uima.cas.impl.FSIntIteratorImplBase;

class IntIterator4bag<T extends FeatureStructure>
extends FSIntIteratorImplBase<T> {
    private int itPos;
    private final FSBagIndex<T> fsBagIndex;

    IntIterator4bag(FSBagIndex<T> fsBagIndex, int[] detectIllegalIndexUpdates) {
        super(fsBagIndex, detectIllegalIndexUpdates);
        this.fsBagIndex = fsBagIndex;
        this.moveToFirst();
    }

    @Override
    public boolean isValid() {
        return this.fsBagIndex.isValid(this.itPos);
    }

    @Override
    public void moveToFirst() {
        this.resetConcurrentModification();
        this.itPos = this.fsBagIndex.moveToFirst();
    }

    @Override
    public void moveToLast() {
        this.resetConcurrentModification();
        this.itPos = this.fsBagIndex.moveToLast();
    }

    @Override
    public void moveToNext() {
        this.checkConcurrentModification();
        this.itPos = this.fsBagIndex.moveToNext(this.itPos);
    }

    @Override
    public void moveToPrevious() {
        this.checkConcurrentModification();
        this.itPos = this.fsBagIndex.moveToPrevious(this.itPos);
    }

    @Override
    public int get() {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        this.checkConcurrentModification();
        return this.fsBagIndex.get(this.itPos);
    }

    @Override
    public Object copy() {
        IntIterator4bag<T> copy = new IntIterator4bag<T>(this.fsBagIndex, this.detectIllegalIndexUpdates);
        copy.itPos = this.itPos;
        return copy;
    }

    @Override
    public void moveTo(int i) {
        this.resetConcurrentModification();
        this.itPos = this.fsBagIndex.findLeftmost(i);
    }

    @Override
    public int ll_indexSize() {
        return this.fsBagIndex.size();
    }
}

