/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.HistoryList;
import org.maltparser.parser.history.HistoryStructure;
import org.maltparser.parser.history.action.GuideUserAction;

public class ParserState {
    private AbstractParserFactory factory;
    private Algorithm algorithm;
    private SymbolTableHandler symboltables;
    private GuideUserHistory history;
    private TransitionSystem transitionSystem;
    private HistoryStructure historyStructure;
    private ParserConfiguration config;

    public ParserState(Algorithm algorithm, AbstractParserFactory factory) throws MaltChainedException {
        this(algorithm, factory, 1);
    }

    public ParserState(Algorithm algorithm, AbstractParserFactory factory, int k) throws MaltChainedException {
        this.setAlgorithm(algorithm);
        this.setFactory(factory);
        this.setSymboltables(algorithm.getManager().getSymbolTables());
        this.setHistoryStructure(new HistoryList());
        this.setTransitionSystem(factory.makeTransitionSystem());
        String decisionSettings = algorithm.getManager().getOptionValue("guide", "decision_settings").toString().trim();
        this.getTransitionSystem().initTableHandlers(decisionSettings, this.symboltables);
        this.setHistory(new History(decisionSettings, algorithm.getManager().getOptionValue("guide", "classitem_separator").toString(), this.getTransitionSystem().getTableHandlers()));
        this.getTransitionSystem().initTransitionSystem(this.history);
        this.config = this.getFactory().makeParserConfiguration();
    }

    public void clear() throws MaltChainedException {
        this.history.clear();
        this.historyStructure.clear();
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public SymbolTableHandler getSymboltables() {
        return this.symboltables;
    }

    protected void setSymboltables(SymbolTableHandler symboltables) {
        this.symboltables = symboltables;
    }

    public GuideUserHistory getHistory() {
        return this.history;
    }

    protected void setHistory(GuideUserHistory history) {
        this.history = history;
    }

    public TransitionSystem getTransitionSystem() {
        return this.transitionSystem;
    }

    protected void setTransitionSystem(TransitionSystem transitionSystem) {
        this.transitionSystem = transitionSystem;
    }

    public HistoryStructure getHistoryStructure() {
        return this.historyStructure;
    }

    protected void setHistoryStructure(HistoryStructure historyStructure) {
        this.historyStructure = historyStructure;
    }

    public void initialize(DependencyStructure dependencyStructure) throws MaltChainedException {
        this.config.clear();
        this.config.setDependencyGraph(dependencyStructure);
        this.config.initialize(null);
    }

    public boolean isTerminalState() throws MaltChainedException {
        return this.config.isTerminalState();
    }

    public boolean permissible(GuideUserAction currentAction) throws MaltChainedException {
        return this.transitionSystem.permissible(currentAction, this.config);
    }

    public void apply(GuideUserAction currentAction) throws MaltChainedException {
        this.transitionSystem.apply(currentAction, this.config);
    }

    public int nConfigurations() throws MaltChainedException {
        return 1;
    }

    public ParserConfiguration getConfiguration() {
        return this.config;
    }

    public AbstractParserFactory getFactory() {
        return this.factory;
    }

    public void setFactory(AbstractParserFactory factory) {
        this.factory = factory;
    }
}

