# Generated by default/object.tt
package Paws::ES::ScheduledAutoTuneDetails;
  use Moose;
  has Action => (is => 'ro', isa => 'Str');
  has ActionType => (is => 'ro', isa => 'Str');
  has Date => (is => 'ro', isa => 'Str');
  has Severity => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::ScheduledAutoTuneDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::ScheduledAutoTuneDetails object:

  $service_obj->Method(Att1 => { Action => $value, ..., Severity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::ScheduledAutoTuneDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Specifies details of the scheduled Auto-Tune action. See the Developer
Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.

=head1 ATTRIBUTES


=head2 Action => Str

Specifies Auto-Tune action description.


=head2 ActionType => Str

Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING
and JVM_YOUNG_GEN_TUNING.


=head2 Date => Str

Specifies timestamp for the Auto-Tune action scheduled for the domain.


=head2 Severity => Str

Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and
HIGH.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

