#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::BidGroupItemStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidGroupItemStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::BidGroupItemStatusCodeType

=head1 DESCRIPTION

This type contains the status of the items within a bid group.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 CurrentBid

(out) The items in the group currently being bid on.



=cut


use constant CurrentBid => scalar('CurrentBid');


=head2 Cancelled

(out) Items in the group that were not bid on because a user retracted a bid
and closed his group or because eBay Customer Support ended a group and all
the active and pending items within that group were cancelled.



=cut


use constant Cancelled => scalar('Cancelled');


=head2 Pending

(out) Items in the bid group that are currently active, but have not yet been
bid on.



=cut


use constant Pending => scalar('Pending');


=head2 Skipped

(out) Items that have been skipped and not bid on (and bidded has ended).



=cut


use constant Skipped => scalar('Skipped');


=head2 Ended

(out) Item has ended.



=cut


use constant Ended => scalar('Ended');


=head2 Won

(out) Item was purchased and has ended.



=cut


use constant Won => scalar('Won');


=head2 GroupClosed

(out) Item has ended.



=cut


use constant GroupClosed => scalar('GroupClosed');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
